/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.imageviewer.actions.io;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.ImageViewerIO;
import csbase.client.applications.imageviewer.actions.ImageViewerAction;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;

public class ImageViewerSaveAsAction
extends ImageViewerAction {
    public ImageViewerSaveAsAction(ImageViewer application) {
        super(application);
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        ImageViewer application = (ImageViewer)this.getApplication();
        ClientFile currFile = application.getCurrentFile();
        if (currFile == null) {
            return;
        }
        String currFileType = currFile.getType();
        List<String> fileTypes = application.getFileTypes();
        ClientProjectFileChooserUtil.OperationResult result = ClientProjectFileChooserUtil.browseSingleFileInSaveMode(application, fileTypes, currFileType, false, null, true);
        if (result == null) {
            return;
        }
        ClientProjectFile outFile = result.getClientProjectFile();
        if (outFile == null) {
            return;
        }
        BufferedImage image = application.getCurrentBufferedImage();
        ImageViewerIO.writeTask(application, image, (ClientFile)outFile);
        application.setCurrentFile((ClientFile)outFile);
        String msg = this.getString("ImageViewerSaveAsAction.success.msg", new Object[0]);
        application.setSaveNeeded(false);
        application.showInformation(msg);
    }

    @Override
    protected ImageIcon getDefaultIcon() {
        return ApplicationImages.ICON_SAVEAS_16;
    }
}

