/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.logadministration;

import csbase.client.ClientLocalFile;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.logadministration.SendLogFilesDialog;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.logic.LogFile;
import csbase.logic.LogFileInfo;
import csbase.logic.Utilities;
import csbase.logic.diagnosticservice.LogType;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.LogAdministrationServiceInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import tecgraf.ftc.common.logic.RemoteFileChannelImpl;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.gui.table.AbstractColumn;
import tecgraf.javautils.gui.table.ColumnsObjectTableModel;
import tecgraf.javautils.gui.table.IColumn;
import tecgraf.javautils.gui.table.ObjectTableBuilder;
import tecgraf.javautils.gui.table.SortableTable;

public class LogAdministration
extends Application {
    JTabbedPane logTypeTabbedPane = new JTabbedPane();
    ObjectTableBuilder<LogFileInfo> tableBuilder;
    private Map<String, JTable> logFileTableMap = new HashMap<String, JTable>();
    private Map<String, String> initialLogDirectoryMap = new HashMap<String, String>();
    private Map<String, String> currentLogDirectoryMap = new HashMap<String, String>();
    private SendLogFilesDialog sendLogFileDialog;
    private File exportTargetDirectory;
    private boolean overwriteAll = false;
    private LogFileInfo[] selectedLogFilesInfo;
    private SendLogFileAction sendLogFileAction = new SendLogFileAction();
    private SaveLogFileAction saveLogFileAction = new SaveLogFileAction();
    private RefreshLogFileTableAction refreshLogFileTableAction = new RefreshLogFileTableAction();
    private LoadParentDirectoryAction loadParentDirectoryAction = new LoadParentDirectoryAction();
    private LoadHomeDirectoryAction loadHomeDirectoryAction = new LoadHomeDirectoryAction();

    public LogAdministration(String id) {
        super(id);
        this.tableBuilder = this.createTableBuilder();
        this.buildFrame();
    }

    @Override
    public void killApplication() throws ApplicationException {
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    private void buildFrame() {
        ApplicationFrame frame = this.getApplicationFrame();
        frame.setLayout(new BorderLayout());
        frame.setSize(500, 300);
        frame.setJMenuBar(this.buildMenu());
        Container appContentPane = frame.getContentPane();
        appContentPane.add((Component)this.buildToolBar(), "North");
        this.buildTypeTabbedPane();
        frame.add((Component)this.logTypeTabbedPane, "Center");
        this.sendLogFileDialog = new SendLogFilesDialog(this);
        this.sendLogFileDialog.setVisible(false);
    }

    private void buildTypeTabbedPane() {
        LoadLogTypesTask task = new LoadLogTypesTask();
        ApplicationFrame frame = this.getApplicationFrame();
        if (!task.execute(frame, this.getString("loadlogfilestask.title"), this.getString("loadlogfilestask.message"))) {
            return;
        }
        LogType[] logTypes = (LogType[])task.getResult();
        if (logTypes.length == 0) {
            JPanel panel = new JPanel(false);
            JLabel label = new JLabel(this.getString("no.initial.directory"));
            label.setHorizontalAlignment(0);
            panel.setLayout(new GridLayout(1, 1));
            panel.add(label);
            this.logTypeTabbedPane.addTab(this.getString("error.tab.title"), panel);
            this.saveLogFileAction.setEnabled(false);
            this.sendLogFileAction.setEnabled(false);
            this.refreshLogFileTableAction.setEnabled(false);
            this.loadParentDirectoryAction.setEnabled(false);
            return;
        }
        for (LogType type : logTypes) {
            SortableTable logFileTable = this.buildFileTable(type.name, type.dir);
            this.logFileTableMap.put(type.name, (JTable)logFileTable);
            this.currentLogDirectoryMap.put(type.name, type.dir);
            this.initialLogDirectoryMap.put(type.name, type.dir);
            this.logTypeTabbedPane.addTab(type.name, this.buildFileTablePanel((Component)logFileTable));
        }
        this.logTypeTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    String type = LogAdministration.this.getActiveLogType();
                    if (((String)LogAdministration.this.currentLogDirectoryMap.get(type)).equals(LogAdministration.this.initialLogDirectoryMap.get(type))) {
                        LogAdministration.this.loadParentDirectoryAction.setEnabled(false);
                    } else {
                        LogAdministration.this.loadParentDirectoryAction.setEnabled(true);
                    }
                }
            }
        });
    }

    private JPanel buildFileTablePanel(Component c) {
        JPanel fileTablePanel = new JPanel(new BorderLayout());
        fileTablePanel.add((Component)new JScrollPane(c), "Center");
        return fileTablePanel;
    }

    private SortableTable buildFileTable(String type, String dir) {
        LoadLogFilesTask task = new LoadLogFilesTask(type, dir);
        ApplicationFrame frame = this.getApplicationFrame();
        if (!task.execute(frame, this.getString("loadlogfilestask.title"), this.getString("loadlogfilestask.message"))) {
            return null;
        }
        LogFileInfo[] logFiles = (LogFileInfo[])task.getResult();
        if (logFiles == null) {
            this.showInvalidParentDirectoryErroDialog();
            return null;
        }
        ArrayList<LogFileInfo> logFileList = new ArrayList<LogFileInfo>();
        for (LogFileInfo logFile : logFiles) {
            logFileList.add(logFile);
        }
        SortableTable logFileTable = this.tableBuilder.build(logFileList);
        logFileTable.getColumnModel().getColumn(0).setMaxWidth(36);
        logFileTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LogFileInfo[] selectedFiles;
                if (e.getClickCount() == 2 && (selectedFiles = LogAdministration.this.getSelectedFilesInfo()).length == 1 && selectedFiles[0].isDirectory) {
                    LogAdministration.this.refreshLogFileTable(LogAdministration.this.getActiveLogType(), selectedFiles[0].path);
                }
            }
        });
        return logFileTable;
    }

    private JToolBar buildToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.sendLogFileAction);
        toolBar.add(this.saveLogFileAction);
        toolBar.add(new JToolBar.Separator());
        toolBar.add(this.refreshLogFileTableAction);
        toolBar.add(this.loadParentDirectoryAction);
        this.loadParentDirectoryAction.setEnabled(false);
        toolBar.add(this.loadHomeDirectoryAction);
        return toolBar;
    }

    private JMenuBar buildMenu() {
        JMenu menuFile = new JMenu(this.getString("menu.file"));
        JMenuItem sendLogFileMenu = new JMenuItem(this.sendLogFileAction);
        menuFile.add(sendLogFileMenu);
        JMenuItem saveLogFileMenu = new JMenuItem(this.saveLogFileAction);
        menuFile.add(saveLogFileMenu);
        menuFile.addSeparator();
        JMenuItem refreshLogFileListMenu = new JMenuItem(this.refreshLogFileTableAction);
        menuFile.add(refreshLogFileListMenu);
        JMenuItem loadParentDirectoryMenu = new JMenuItem(this.loadParentDirectoryAction);
        menuFile.add(loadParentDirectoryMenu);
        JMenuItem loadHomeDirectoryMenu = new JMenuItem(this.loadHomeDirectoryAction);
        menuFile.add(loadHomeDirectoryMenu);
        menuFile.addSeparator();
        JMenuItem exitMenu = new JMenuItem(new ApplicationExitAction(this));
        menuFile.add(exitMenu);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menuFile);
        return menuBar;
    }

    private void showEmptyListErroDialog() {
        this.showError(this.getString("emptylist.error.msg"));
    }

    private void showInvalidDirectoryErroDialog() {
        this.showError(this.getString("invalid.directory.error.msg"));
    }

    private void showInvalidParentDirectoryErroDialog() {
        this.showError(this.getString("no.parent.error.msg"));
    }

    private void showExportFileErroDialog() {
        this.showError(this.getString("savelog.error.msg"));
    }

    ObjectTableBuilder<LogFileInfo> createTableBuilder() {
        ObjectTableBuilder tableBuilder = new ObjectTableBuilder(new IColumn[]{new DirColumn(), new NameColumn(), new SizeColumn(), new LastModifiedColumn()});
        tableBuilder.setColumnsWidthPolicy(ObjectTableBuilder.ColumnsWidthPolicy.ADJUST_BY_DATA_DYNAMIC);
        tableBuilder.setSelectionMode(ObjectTableBuilder.SelectionMode.SINGLE_SELECTION);
        tableBuilder.setSortOrder(1, SortOrder.ASCENDING);
        return tableBuilder;
    }

    SortableTable getActiveFileTable() {
        return (SortableTable)SortableTable.class.cast(this.logFileTableMap.get(this.logTypeTabbedPane.getTitleAt(this.logTypeTabbedPane.getSelectedIndex())));
    }

    String getActiveDirectory() {
        return this.currentLogDirectoryMap.get(this.logTypeTabbedPane.getTitleAt(this.logTypeTabbedPane.getSelectedIndex()));
    }

    String getInitialDirectory() {
        return this.initialLogDirectoryMap.get(this.logTypeTabbedPane.getTitleAt(this.logTypeTabbedPane.getSelectedIndex()));
    }

    String getActiveLogType() {
        return this.logTypeTabbedPane.getTitleAt(this.logTypeTabbedPane.getSelectedIndex());
    }

    private JScrollPane getActiveScrollPane() {
        JPanel panel = (JPanel)JPanel.class.cast(this.logTypeTabbedPane.getSelectedComponent());
        for (Component c : panel.getComponents()) {
            if (!(c instanceof JScrollPane)) continue;
            return (JScrollPane)JScrollPane.class.cast(c);
        }
        return null;
    }

    private LogFileInfo[] getSelectedFilesInfo() {
        int[] selectedRows = this.getActiveFileTable().getSelectedRows();
        ColumnsObjectTableModel tableModel = (ColumnsObjectTableModel)this.getActiveFileTable().getModel();
        LogFileInfo[] infos = new LogFileInfo[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            infos[i] = (LogFileInfo)tableModel.getRow(this.getActiveFileTable().convertRowIndexToModel(selectedRows[i]));
        }
        return infos;
    }

    private void refreshLogFileTable(String type, String dir) {
        SortableTable fileTable = this.buildFileTable(type, dir);
        if (fileTable != null) {
            this.getActiveScrollPane().getViewport().setView((Component)fileTable);
            this.logFileTableMap.put(this.logTypeTabbedPane.getTitleAt(this.logTypeTabbedPane.getSelectedIndex()), (JTable)fileTable);
            this.currentLogDirectoryMap.put(type, dir);
            if (this.currentLogDirectoryMap.get(type).equals(this.initialLogDirectoryMap.get(type))) {
                this.loadParentDirectoryAction.setEnabled(false);
            } else {
                this.loadParentDirectoryAction.setEnabled(true);
            }
        }
    }

    private void saveFile(File directory, LogFile logFile) throws IOException {
        File localFile = new File(directory.getCanonicalPath() + File.separator + logFile.name);
        if (localFile.exists()) {
            boolean overwriteOnce = false;
            if (!this.overwriteAll) {
                String[] opts = new String[]{"Sim para todos", "Sim", "N\u00e3o"};
                int opt = logFile.isDirectory ? this.showOptionDialog(this.getApplicationFrame(), "Diret\u00f3rio " + localFile.getAbsoluteFile() + " j\u00e1 existe. Sobrescrever?", opts) : this.showOptionDialog(this.getApplicationFrame(), "Arquivo " + localFile.getAbsoluteFile() + " j\u00e1 existe. Sobrescrever?", opts);
                switch (opt) {
                    case 0: {
                        this.overwriteAll = true;
                        break;
                    }
                    case 1: {
                        overwriteOnce = true;
                        break;
                    }
                }
            }
            if (this.overwriteAll || overwriteOnce) {
                FileUtils.delete((File)localFile);
            } else {
                return;
            }
        }
        if (logFile.isDirectory) {
            localFile.mkdir();
            for (LogFile child : logFile.children) {
                this.saveFile(localFile, child);
            }
        } else {
            if (!localFile.createNewFile()) {
                throw new IOException("Erro ao criar arquivo " + localFile.getAbsolutePath());
            }
            if (!localFile.canWrite()) {
                localFile.setWritable(true);
            }
            byte[] data = this.readRemoteFile(logFile.channel);
            try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(localFile.getCanonicalPath()));){
                ((OutputStream)output).write(data);
            }
        }
    }

    String getParentDir(String dir) {
        int lastSeparatorIdx = dir.lastIndexOf("/");
        if (lastSeparatorIdx == -1) {
            lastSeparatorIdx = dir.lastIndexOf(File.separator);
        }
        if (lastSeparatorIdx == 0) {
            return dir.substring(lastSeparatorIdx, lastSeparatorIdx + 1);
        }
        if (lastSeparatorIdx == dir.length() - 1) {
            return this.getParentDir(dir.substring(0, dir.length() - 1));
        }
        return dir.substring(0, lastSeparatorIdx);
    }

    public byte[] readRemoteFile(RemoteFileChannelInfo channel) {
        try {
            RemoteFileChannelImpl rfc = new RemoteFileChannelImpl(channel.getIdentifier(), false, channel.getHost(), channel.getPort(), channel.getKey());
            rfc.open(true);
            int fileSize = (int)rfc.getSize();
            byte[] buffer = new byte[fileSize];
            if (fileSize != 0) {
                rfc.read(buffer);
            }
            rfc.close();
            return buffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ LogFileInfo[] access$602(LogAdministration x0, LogFileInfo[] x1) {
        x0.selectedLogFilesInfo = x1;
        return x1;
    }

    private class LastModifiedColumn
    extends AbstractColumn<LogFileInfo> {
        protected LastModifiedColumn() {
            super(Long.class);
        }

        public String getColumnName() {
            return LogAdministration.this.getString("fileloglist.column.name.last");
        }

        public Object getValue(LogFileInfo obj) {
            return obj.lastModified;
        }

        public TableCellRenderer createTableCellRenderer() {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    String v = Utilities.getFormattedDate((Date)new Date((Long)value), (String)"dd/MM/yyyy HH:mm:ss");
                    this.setText(v.toString());
                    this.setHorizontalAlignment(4);
                    return this;
                }
            };
        }
    }

    private class SizeColumn
    extends AbstractColumn<LogFileInfo> {
        protected SizeColumn() {
            super(Long.class);
        }

        public String getColumnName() {
            return LogAdministration.this.getString("fileloglist.column.name.size");
        }

        public Object getValue(LogFileInfo obj) {
            return obj.size;
        }

        public TableCellRenderer createTableCellRenderer() {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    Long v = (Long)value;
                    this.setText(FormatUtils.formatSize((long)v, (int)0));
                    this.setHorizontalAlignment(4);
                    return this;
                }
            };
        }
    }

    private class NameColumn
    extends AbstractColumn<LogFileInfo> {
        protected NameColumn() {
            super(String.class);
        }

        public String getColumnName() {
            return LogAdministration.this.getString("fileloglist.column.name.name");
        }

        public Object getValue(LogFileInfo obj) {
            return obj.name;
        }
    }

    private class DirColumn
    extends AbstractColumn<LogFileInfo> {
        protected DirColumn() {
            super(ImageIcon.class);
        }

        public String getColumnName() {
            return "";
        }

        public Object getValue(LogFileInfo obj) {
            if (obj.isDirectory) {
                return ApplicationImages.ICON_FOLDER_16;
            }
            return ApplicationImages.ICON_FILE_16;
        }
    }

    private class DownloadLogFilesTask
    extends RemoteTask<LogFile[]> {
        private DownloadLogFilesTask() {
        }

        protected void performTask() throws Exception {
            LogAdministrationServiceInterface logAdministrationService = ClientRemoteLocator.logAdministrationService;
            String[] selectedFilesPath = new String[LogAdministration.this.selectedLogFilesInfo.length];
            for (int i = 0; i < LogAdministration.this.selectedLogFilesInfo.length; ++i) {
                selectedFilesPath[i] = ((LogAdministration)LogAdministration.this).selectedLogFilesInfo[i].path;
            }
            this.setResult(logAdministrationService.downloadLogFile(selectedFilesPath));
        }
    }

    private class LoadLogFilesTask
    extends RemoteTask<LogFileInfo[]> {
        String type;
        String dir;

        public LoadLogFilesTask(String type, String dir) {
            this.type = type;
            this.dir = dir;
        }

        protected void performTask() throws Exception {
            LogAdministrationServiceInterface logAdministrationService = ClientRemoteLocator.logAdministrationService;
            LogFileInfo[] fileList = logAdministrationService.listLogFiles(this.type, this.dir);
            this.setResult(fileList);
        }
    }

    private class LoadLogTypesTask
    extends RemoteTask<LogType[]> {
        private LoadLogTypesTask() {
        }

        protected void performTask() throws Exception {
            LogAdministrationServiceInterface logAdministrationService = ClientRemoteLocator.logAdministrationService;
            LogType[] typeList = logAdministrationService.getLogTypes();
            this.setResult(typeList);
        }
    }

    private class SaveLogFileAction
    extends AbstractAction {
        protected SaveLogFileAction() {
            this.putValue("SmallIcon", ApplicationImages.ICON_EXPORT_16);
            this.putValue("ShortDescription", LogAdministration.this.getString("action.save.log.tooltip"));
            this.putValue("Name", LogAdministration.this.getString("action.save.log"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LogAdministration.access$602(LogAdministration.this, LogAdministration.this.getSelectedFilesInfo());
            if (LogAdministration.this.selectedLogFilesInfo.length == 0) {
                LogAdministration.this.showEmptyListErroDialog();
            } else {
                ClientLocalFile localDir = ClientLocalFileChooserUtil.browseSingleDirectoryInOpenMode(LogAdministration.this.getApplicationFrame(), Collections.emptyList(), LogAdministration.this.getString("savelogdialog.approve.button"), false, null);
                if (localDir != null) {
                    if (!localDir.exists()) {
                        LogAdministration.this.showInvalidDirectoryErroDialog();
                        return;
                    }
                    LogAdministration.this.exportTargetDirectory = new File(localDir.getStringPath());
                    DownloadLogFilesTask task = new DownloadLogFilesTask();
                    if (!task.execute(LogAdministration.this.getApplicationFrame(), LogAdministration.this.getString("savelogfilestask.message"), LogAdministration.this.getString("savelogfilestask.title"))) {
                        LogAdministration.this.showExportFileErroDialog();
                    }
                    LogFile[] logFiles = (LogFile[])task.getResult();
                    LogAdministration.this.overwriteAll = false;
                    for (LogFile file : logFiles) {
                        try {
                            LogAdministration.this.saveFile(LogAdministration.this.exportTargetDirectory, file);
                        }
                        catch (IOException e) {
                            LogAdministration.this.showExportFileErroDialog();
                        }
                    }
                }
            }
        }
    }

    private class SendLogFileAction
    extends AbstractAction {
        protected SendLogFileAction() {
            this.putValue("SmallIcon", ApplicationImages.ICON_SENDMAIL_16);
            this.putValue("ShortDescription", LogAdministration.this.getString("action.send.email.tooltip"));
            this.putValue("Name", LogAdministration.this.getString("action.send.email"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LogAdministration.access$602(LogAdministration.this, LogAdministration.this.getSelectedFilesInfo());
            if (LogAdministration.this.selectedLogFilesInfo.length == 0) {
                LogAdministration.this.showEmptyListErroDialog();
            } else {
                LogAdministration.this.sendLogFileDialog.updateSelectedFiles(LogAdministration.this.selectedLogFilesInfo);
                LogAdministration.this.sendLogFileDialog.setVisible(true);
            }
        }
    }

    private class RefreshLogFileTableAction
    extends AbstractAction {
        protected RefreshLogFileTableAction() {
            this.putValue("SmallIcon", ApplicationImages.ICON_REFRESH_16);
            this.putValue("ShortDescription", LogAdministration.this.getString("action.refresh.loglist.tooltip"));
            this.putValue("Name", LogAdministration.this.getString("action.refresh.loglist"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LogAdministration.this.refreshLogFileTable(LogAdministration.this.getActiveLogType(), LogAdministration.this.getActiveDirectory());
        }
    }

    private class LoadHomeDirectoryAction
    extends AbstractAction {
        protected LoadHomeDirectoryAction() {
            this.putValue("SmallIcon", ApplicationImages.ICON_BROWSELOCALFILE_16);
            this.putValue("ShortDescription", LogAdministration.this.getString("action.to.home.tooltip"));
            this.putValue("Name", LogAdministration.this.getString("action.to.home"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LogAdministration.this.refreshLogFileTable(LogAdministration.this.getActiveLogType(), LogAdministration.this.getInitialDirectory());
        }
    }

    private class LoadParentDirectoryAction
    extends AbstractAction {
        protected LoadParentDirectoryAction() {
            this.putValue("SmallIcon", ApplicationImages.ICON_UP_16);
            this.putValue("ShortDescription", LogAdministration.this.getString("action.to.parent.tooltip"));
            this.putValue("Name", LogAdministration.this.getString("action.to.parent"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LogAdministration.this.refreshLogFileTable(LogAdministration.this.getActiveLogType(), LogAdministration.this.getParentDir(LogAdministration.this.getActiveDirectory()));
        }
    }
}

