/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsynchronization;

import csbase.client.applications.projectsynchronization.PanelServerSelection;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.CardLayout;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class ContainerSelectionServers {
    private JPanel rootPanel;
    private JPanel projectsPanel;
    private PanelServerSelection serverSelectionA;
    private PanelServerSelection serverSelectionB;
    private ApplicationRegistry registry;
    private String remoteServer;
    private String remotePort;

    public ContainerSelectionServers(ApplicationRegistry registry, String remoteServer, String remotePort) {
        this.registry = registry;
        this.remoteServer = remoteServer;
        this.remotePort = remotePort;
    }

    public JPanel getRootPanel() {
        if (this.rootPanel == null) {
            this.rootPanel = new JPanel();
            CardLayout cardLayout = new CardLayout();
            cardLayout.setHgap(3);
            cardLayout.setVgap(3);
            this.rootPanel.setLayout(cardLayout);
            this.rootPanel.add("projectsPanel", this.getProjectsPanel());
        }
        return this.rootPanel;
    }

    public JPanel getProjectsPanel() {
        if (this.projectsPanel == null) {
            this.projectsPanel = new JPanel(new GridLayout(1, 2));
            this.projectsPanel.add(this.getServerSelectionA());
            this.projectsPanel.add(this.getServerSelectionB());
        }
        return this.projectsPanel;
    }

    public PanelServerSelection getServerSelectionA() {
        if (this.serverSelectionA == null) {
            this.serverSelectionA = new PanelServerSelection(this.registry.getString("step1.server.a"), this.registry, null, null);
        }
        return this.serverSelectionA;
    }

    public PanelServerSelection getServerSelectionB() {
        if (this.serverSelectionB == null) {
            this.serverSelectionB = new PanelServerSelection(this.registry.getString("step1.server.b"), this.registry, this.remoteServer, this.remotePort);
        }
        return this.serverSelectionB;
    }
}

