/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v2.command;

import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandNotification;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.ExtendedCommandFinishedNotification;
import csdk.v2.api.command.ICommandInfo;

public class CSDKCommandInfo
implements ICommandInfo {
    private final CommandNotification data;

    public CSDKCommandInfo(CommandNotification data) {
        this.data = data;
    }

    public String getCommandId() {
        return this.data.getCommandId().toString();
    }

    public ICommandInfo.FinalizationType getFinalizationType() {
        CommandFinalizationInfo finalizationInfo = this.data.getFinalizationInfo();
        CommandFinalizationType type = finalizationInfo.getFinalizationType();
        switch (type) {
            case END: {
                return ICommandInfo.FinalizationType.COMPLETED;
            }
            case EXECUTION_ERROR: {
                return ICommandInfo.FinalizationType.ERROR;
            }
            case FAILED: {
                return ICommandInfo.FinalizationType.INIT_FAILURE;
            }
            case KILLED: {
                return ICommandInfo.FinalizationType.KILLED;
            }
            case LOST: {
                return ICommandInfo.FinalizationType.LOST;
            }
            case NO_EXIT_CODE: {
                return ICommandInfo.FinalizationType.NO_CODE;
            }
            case SUCCESS: {
                return ICommandInfo.FinalizationType.SUCCESS;
            }
        }
        throw new IllegalArgumentException("Tipo do evento inv\u00e1lido: " + type);
    }

    public String getExecutionHost() {
        Object execHost = this.data.getExecHost();
        if (execHost != null) {
            return execHost.toString();
        }
        return null;
    }

    public String getDescription() {
        return this.data.getCmdDesc();
    }

    public Integer getExitCode() {
        CommandFinalizationInfo finalizationInfo = this.data.getFinalizationInfo();
        return finalizationInfo.getExitCode();
    }

    public String getProjectId() {
        return this.data.getProjectId().toString();
    }

    public Long getStartTime() {
        return this.data.getStartTime();
    }

    public Integer getGuiltyNodeId() {
        CommandFinalizationInfo finalizationInfo = this.data.getFinalizationInfo();
        CommandFinalizationInfo.FinalizationInfoType infoType = finalizationInfo.getInfoType();
        if (infoType.equals((Object)CommandFinalizationInfo.FinalizationInfoType.EXTENDED)) {
            ExtendedCommandFinalizationInfo extendedInfo = (ExtendedCommandFinalizationInfo)finalizationInfo;
            return extendedInfo.getGuiltyNodeId();
        }
        return null;
    }

    public Integer getCPUTimeSec() {
        if (this.data instanceof ExtendedCommandFinishedNotification) {
            ExtendedCommandFinishedNotification timedData = (ExtendedCommandFinishedNotification)this.data;
            return timedData.getCPUTime();
        }
        return null;
    }

    public Integer getElapsedTimeSec() {
        if (this.data instanceof ExtendedCommandFinishedNotification) {
            ExtendedCommandFinishedNotification timedData = (ExtendedCommandFinishedNotification)this.data;
            return timedData.getElapsedTime();
        }
        return null;
    }

    public Long getEndTime() {
        if (this.data instanceof ExtendedCommandFinishedNotification) {
            ExtendedCommandFinishedNotification timedData = (ExtendedCommandFinishedNotification)this.data;
            return timedData.getEndTime();
        }
        return null;
    }

    public Integer getUserTimeSec() {
        if (this.data instanceof ExtendedCommandFinishedNotification) {
            ExtendedCommandFinishedNotification timedData = (ExtendedCommandFinishedNotification)this.data;
            return timedData.getUserTime();
        }
        return null;
    }
}

