/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias.server;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.manager.server.ServerInfoManager;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ServerURI;
import csbase.logic.server.ServerInfo;
import csbase.logic.server.ServerInfoData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public final class ServerInfoDialog {
    private JFrame parent;
    private ServerInfo serverInfo;
    private DesktopComponentDialog dialog;
    private String windowLabel;
    private JButton actionButton;
    private JTextField serverNameTextField;
    private JCheckBox serverSuspendedCheckBox;
    private static final int SERVER_TEXTFIELD_COLUMNS = 25;
    private JCheckBox serverIsLocalCheckBox;
    private JTextField serverURITextField;

    public ServerInfoDialog(JFrame parent) {
        this.parent = parent;
        this.windowLabel = LNG.get((String)"IAS_SERVER_ADD_TITLE");
        this.display();
    }

    public ServerInfoDialog(JFrame parent, ServerInfo serverInfo) {
        if (serverInfo == null) {
            throw new IllegalArgumentException("O servidor n\u00e3o pode ser nulo.");
        }
        this.parent = parent;
        this.windowLabel = LNG.get((String)"IAS_SERVER_UPDATE_TITLE");
        this.serverInfo = serverInfo;
        this.display();
    }

    private void display() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.addContentPanel(mainPanel);
        this.addButtonPanel(mainPanel);
        this.dialog = new DesktopComponentDialog((Window)this.parent, this.windowLabel);
        this.dialog.getContentPane().add(mainPanel);
        this.dialog.getRootPane().setDefaultButton(this.actionButton);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.pack();
        this.dialog.center(this.parent);
        this.dialog.setVisible(true);
    }

    private void addContentPanel(JPanel mainPanel) {
        this.serverNameTextField = new JTextField(25);
        this.serverURITextField = new JTextField(25);
        if (this.serverInfo != null) {
            this.serverNameTextField.setText(this.serverInfo.getName());
            this.serverURITextField.setText(this.serverInfo.getURI().toString());
        }
        ServerInfoDocumentListener serverInfoDocListener = new ServerInfoDocumentListener();
        this.serverNameTextField.getDocument().addDocumentListener(serverInfoDocListener);
        this.serverURITextField.getDocument().addDocumentListener(serverInfoDocListener);
        this.serverSuspendedCheckBox = new JCheckBox();
        this.serverIsLocalCheckBox = new JCheckBox();
        if (this.serverInfo != null) {
            this.serverSuspendedCheckBox.setSelected(this.serverInfo.isSuspended());
            this.serverIsLocalCheckBox.setSelected(this.serverInfo.isLocal());
        }
        JPanel contentPanel = GUIUtils.createBasicGridPanel((JComponent[][])new JComponent[][]{{new JLabel(LNG.get((String)"IAS_SERVER_NAME")), this.serverNameTextField}, {new JLabel(LNG.get((String)"IAS_SERVER_URI")), this.serverURITextField}, {new JLabel(LNG.get((String)"IAS_SERVER_SUSPENDED")), this.serverSuspendedCheckBox}, {new JLabel(LNG.get((String)"IAS_SERVER_LOCAL")), this.serverIsLocalCheckBox}});
        contentPanel.setBorder(BorderFactory.createTitledBorder(LNG.get((String)"IAS_SERVER_REGISTRATION")));
        mainPanel.add((Component)contentPanel, "Center");
    }

    private void addButtonPanel(JPanel mainPanel) {
        JPanel buttonPanel = new JPanel();
        if (this.serverInfo == null) {
            this.actionButton = new JButton(LNG.get((String)"IAS_ADD"));
            this.actionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!ServerURI.isValid((String)ServerInfoDialog.this.serverURITextField.getText())) {
                        StandardDialogs.showErrorDialog((Component)ServerInfoDialog.this.parent, (String)LNG.get((String)"IAS_SERVER_UPDATE_TITLE"), (String)LNG.get((String)"UTIL_INVALID_URI"));
                        return;
                    }
                    try {
                        if (ServerInfoDialog.this.addServerInfo()) {
                            ServerInfoDialog.this.dialog.dispose();
                        } else {
                            StandardErrorDialogs.showErrorDialog((Window)ServerInfoDialog.this.dialog, LNG.get((String)"IAS_SERVER_ADD_TITLE"), MessageFormat.format(LNG.get((String)"IAS_SERVER_ALREADY_EXISTS_MESSAGE"), ServerInfoDialog.this.serverNameTextField.getText()));
                        }
                    }
                    catch (Exception exception) {
                        StandardErrorDialogs.showErrorDialog(ServerInfoDialog.this.dialog, LNG.get((String)"IAS_SERVER_ADD_TITLE"), MessageFormat.format(LNG.get((String)"IAS_SERVER_ADDING_ERROR"), ServerInfoDialog.this.serverNameTextField.getText()), exception);
                    }
                }
            });
        } else {
            this.actionButton = new JButton(LNG.get((String)"IAS_UPDATE"));
            this.actionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!ServerURI.isValid((String)ServerInfoDialog.this.serverURITextField.getText())) {
                        StandardDialogs.showErrorDialog((Component)ServerInfoDialog.this.parent, (String)LNG.get((String)"IAS_SERVER_UPDATE_TITLE"), (String)LNG.get((String)"UTIL_INVALID_URI"));
                        return;
                    }
                    try {
                        if (ServerInfoDialog.this.updateServerInfo()) {
                            ServerInfoDialog.this.dialog.dispose();
                        } else {
                            StandardErrorDialogs.showErrorDialog((Window)ServerInfoDialog.this.dialog, LNG.get((String)"IAS_SERVER_UPDATE_TITLE"), MessageFormat.format(LNG.get((String)"IAS_SERVER_ALREADY_EXISTS_MESSAGE"), ServerInfoDialog.this.serverNameTextField.getText()));
                        }
                    }
                    catch (Exception exception) {
                        StandardErrorDialogs.showErrorDialog(ServerInfoDialog.this.dialog, LNG.get((String)"IAS_SERVER_UPDATE_TITLE"), MessageFormat.format(LNG.get((String)"IAS_SERVER_UPDATING_ERROR"), ServerInfoDialog.this.serverInfo.getName()), exception);
                    }
                }
            });
        }
        if (this.serverInfo == null) {
            this.actionButton.setEnabled(false);
        } else {
            this.actionButton.setEnabled(true);
        }
        buttonPanel.add(this.actionButton);
        JButton cancelButton = new JButton(LNG.get((String)"IAS_CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerInfoDialog.this.dialog.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        mainPanel.add((Component)buttonPanel, "South");
    }

    private boolean updateServerInfo() throws Exception {
        RemoteTask<Boolean> modifyLocalServerTask = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                this.setResult(new Boolean(ServerInfoManager.getInstance().modifyServerInfo(ServerInfoDialog.this.serverInfo, new ServerInfoData(ServerInfoDialog.this.serverNameTextField.getText().trim(), ServerInfoDialog.this.serverSuspendedCheckBox.isSelected(), ServerInfoDialog.this.serverIsLocalCheckBox.isSelected(), ServerURI.parse((String)ServerInfoDialog.this.serverURITextField.getText())))));
            }
        };
        if (modifyLocalServerTask.execute(this.dialog, LNG.get((String)"IAS_SERVER_UPDATE_TITLE"), LNG.get((String)"IAS_SERVER_UPDATING_MESSAGE"))) {
            return (Boolean)modifyLocalServerTask.getResult();
        }
        throw modifyLocalServerTask.getError();
    }

    private boolean addServerInfo() throws Exception {
        final ServerInfoData newLocalServer = new ServerInfoData(this.serverNameTextField.getText().trim(), this.serverSuspendedCheckBox.isSelected(), this.serverIsLocalCheckBox.isSelected(), ServerURI.parse((String)this.serverURITextField.getText()));
        RemoteTask<Boolean> addLocalServerTask = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                this.setResult(new Boolean(ServerInfoManager.getInstance().addServerInfo(newLocalServer)));
            }
        };
        if (addLocalServerTask.execute(this.dialog, LNG.get((String)"IAS_SERVER_ADD_TITLE"), MessageFormat.format(LNG.get((String)"IAS_SERVER_ADDING_MESSAGE"), newLocalServer.getName()))) {
            Boolean result = (Boolean)addLocalServerTask.getResult();
            return result;
        }
        throw addLocalServerTask.getError();
    }

    private class ServerInfoDocumentListener
    implements DocumentListener {
        private ServerInfoDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            Document serverNameDoc = ServerInfoDialog.this.serverNameTextField.getDocument();
            Document serverURIDoc = ServerInfoDialog.this.serverURITextField.getDocument();
            String serverName = "";
            String serverURIStr = "";
            try {
                serverName = serverNameDoc.getText(0, serverNameDoc.getLength()).trim();
                serverURIStr = serverURIDoc.getText(0, serverURIDoc.getLength()).trim();
            }
            catch (BadLocationException ble) {
                StandardErrorDialogs.showErrorDialog(ServerInfoDialog.this.dialog, LNG.get((String)"IAS_SERVER_GET_TEXT_ERROR_TITLE"), LNG.get((String)"IAS_SERVER_GET_TEXT_ERROR_MESSAGE"), ble);
            }
            if (serverName.length() == 0 || serverURIStr.length() == 0) {
                ServerInfoDialog.this.actionButton.setEnabled(false);
            } else {
                ServerInfoDialog.this.actionButton.setEnabled(true);
            }
        }
    }
}

