/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.editors;

import csbase.client.applicationmanager.resourcehelpers.AlgorithmSelectionDialog;
import csbase.client.applications.ApplicationImages;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import tecgraf.javautils.gui.GBC;

public class FavoriteAlgorithmsEditor
extends PreferenceEditor<List<String>> {
    public FavoriteAlgorithmsEditor(PreferenceValue<List<String>> pv) {
        super(pv);
    }

    @Override
    protected JComponent createComponent() {
        AbstractTableModel model = new AbstractTableModel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return ((List)FavoriteAlgorithmsEditor.this.getValue()).get(rowIndex);
            }

            @Override
            public int getRowCount() {
                return ((List)FavoriteAlgorithmsEditor.this.getValue()).size();
            }

            @Override
            public String getColumnName(int column) {
                return null;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }
        };
        JTable table = new JTable();
        table.setModel(model);
        table.setSelectionMode(2);
        table.setShowHorizontalLines(false);
        table.setDefaultRenderer(Object.class, new InternalRenderer());
        JScrollPane pane = new JScrollPane(table);
        pane.setPreferredSize(new Dimension(400, 150));
        JToolBar toolbar = this.buildToolbar(table);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)pane, new GBC(0, 0).both());
        panel.add((Component)toolbar, new GBC(1, 0).vertical());
        this.setTitledBorder(panel);
        return panel;
    }

    private JToolBar buildToolbar(JTable table) {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        AbstractAction addAction = this.buildAddAction(table);
        AbstractAction delAction = this.buildDelAction(table);
        addAction.setEnabled(this.isEditable());
        delAction.setEnabled(this.isEditable());
        toolbar.add(addAction);
        toolbar.add(delAction);
        return toolbar;
    }

    private AbstractAction buildDelAction(final JTable table) {
        AbstractAction delAction = new AbstractAction(null, ApplicationImages.ICON_ROWDELETE_16){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIds = table.getSelectedRows();
                if (rowIds == null || rowIds.length == 0) {
                    return;
                }
                List value = (List)FavoriteAlgorithmsEditor.this.getValue();
                ArrayList algorithmsToRemove = new ArrayList(rowIds.length);
                for (int rowId : rowIds) {
                    algorithmsToRemove.add(value.get(rowId));
                }
                value.removeAll(algorithmsToRemove);
                FavoriteAlgorithmsEditor.this.updateTable(table);
                FavoriteAlgorithmsEditor.this.notifyListeners();
            }
        };
        return delAction;
    }

    private AbstractAction buildAddAction(final JTable table) {
        AbstractAction addAction = new AbstractAction(null, ApplicationImages.ICON_ADD_16){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList algorithms = FavoriteAlgorithmsEditor.this.getOthersAlgorithmsRegistries();
                AlgorithmSelectionDialog dialog = new AlgorithmSelectionDialog(null, algorithms);
                dialog.setTitle(FavoriteAlgorithmsEditor.this.getLabel());
                dialog.setVisible(true);
                List<String> ids = dialog.getSelectedAlgorithms();
                List value = (List)FavoriteAlgorithmsEditor.this.getValue();
                for (String id : ids) {
                    if (value.contains(id)) continue;
                    value.add(id);
                }
                FavoriteAlgorithmsEditor.this.updateTable(table);
                FavoriteAlgorithmsEditor.this.notifyListeners();
            }
        };
        return addAction;
    }

    private void updateTable(JTable table) {
        ((AbstractTableModel)table.getModel()).fireTableDataChanged();
    }

    private ArrayList<AlgorithmInfo> getOthersAlgorithmsRegistries() {
        AlgorithmInfo[] allInfos = AlgorithmManagementProxy.getAllAlgorithmInfos(null, AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);
        ArrayList<AlgorithmInfo> algorithms = new ArrayList<AlgorithmInfo>();
        for (int i = 0; i < allInfos.length; ++i) {
            AlgorithmInfo info = allInfos[i];
            String id = info.getId();
            if (((List)this.getValue()).contains(id)) continue;
            algorithms.add(info);
        }
        return algorithms;
    }

    public static ImageIcon getIconForVersion(AlgorithmVersionInfo algorithmVersion) {
        if (algorithmVersion != null) {
            AlgorithmConfigurator.ConfiguratorType type = algorithmVersion.getType();
            if (type == AlgorithmConfigurator.ConfiguratorType.SIMPLE) {
                return ApplicationImages.ICON_FLOW_NODE_16;
            }
            if (type == AlgorithmConfigurator.ConfiguratorType.FLOW) {
                return ApplicationImages.ICON_FLOW_16;
            }
        }
        return ApplicationImages.ICON_BLANK_16;
    }

    private class InternalRenderer
    extends DefaultTableCellRenderer {
        private final Color LIGHT = new Color(15266558);

        private InternalRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cmp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)cmp;
            label.setText(null);
            label.setIcon(null);
            label.setHorizontalAlignment(10);
            String id = (String)value;
            if (id == null) {
                return label;
            }
            AlgorithmInfo algorithm = AlgorithmManagementProxy.getAlgorithmInfoById(id, null, AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);
            if (algorithm == null) {
                label.setText("!!!");
            } else {
                label.setText(algorithm.getName());
                ImageIcon icon = FavoriteAlgorithmsEditor.getIconForVersion(algorithm.getLastVersion());
                label.setIcon(icon);
            }
            if (!isSelected) {
                label.setBackground(row % 2 == 0 ? Color.WHITE : this.LIGHT);
            }
            return label;
        }
    }
}

