/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.project.ClientProjectFileProperties;
import csbase.client.project.ProjectFileTypeComboBox;
import csbase.client.project.action.ProjectFileTypeComboBoxRenderer;
import csbase.client.project.tasks.ChangeFileTypeTask;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;

public class FileTypeChangeDialog {
    private DesktopComponentDialog dialog = null;
    private Window owner = null;
    private JButton defaultButton;
    private CommonClientProject project;
    private ClientProjectFile file;
    private ProjectFileTypeComboBox fileTypeList;

    public static void show(Window owner, CommonClientProject project, ClientProjectFile file) {
        new FileTypeChangeDialog(owner, project, file);
    }

    private DesktopComponentDialog makeDialog() {
        DesktopComponentDialog d = new DesktopComponentDialog(this.owner, this.getTitle());
        d.setModal(false);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.makePropertiesPanel(d.getBackground()));
        mainPanel.add((Component)this.makeButtonPanel(), "South");
        d.getContentPane().add(mainPanel);
        d.pack();
        d.center(this.owner);
        d.getRootPane().setDefaultButton(this.defaultButton);
        return d;
    }

    private JPanel makePropertiesPanel(Color background) {
        ImageIcon icon = ClientProjectFileProperties.getImageIcon(this.file);
        ProjectFileType type = ProjectFileType.getFileType((String)this.file.getType());
        JTextField nameTextField = new JTextField(this.file.getName());
        nameTextField.setEditable(false);
        String fileLocalization = this.buildLocalization();
        JTextField pathTextField = new JTextField(fileLocalization);
        pathTextField.setEditable(false);
        JLabel typeLabel = new JLabel(icon, 2);
        JTextArea typeTextArea = new JTextArea(" " + type.getDescription());
        typeTextArea.setBackground(background);
        typeTextArea.setEditable(false);
        JPanel typePanel = new JPanel(new FlowLayout(3, 0, 0));
        typePanel.add(typeLabel);
        typePanel.add(typeTextArea);
        ProjectFileTypeComboBox.Mode mode = this.file.isDirectory() ? ProjectFileTypeComboBox.Mode.DIRECTORY_ONLY : ProjectFileTypeComboBox.Mode.FILE_ONLY;
        this.fileTypeList = new ProjectFileTypeComboBox(mode, false);
        if (type != null) {
            this.fileTypeList.selectTypeCode(type.getCode());
        }
        this.fileTypeList.setRenderer(new ProjectFileTypeComboBoxRenderer());
        JComponent[][] rows = new JComponent[][]{{new JLabel(LNG.get((String)"PRJ_FILE_NAME")), nameTextField}, {new JLabel(LNG.get((String)"PRJ_FILE_LOCALIZATION")), pathTextField}, {new JLabel(LNG.get((String)"PRJ_FILE_TYPE")), typePanel}, {new JLabel(LNG.get((String)"PRJ_FILE_NEW_TYPE")), this.fileTypeList}};
        return GUIUtils.createBasicGridPanel((JComponent[][])rows);
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        this.defaultButton = new JButton(LNG.get((String)"PRJ_FILE_TYPE_CHANGE_CONFIRMATION"));
        panel.add(this.defaultButton);
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTypeChangeDialog.this.changeType();
            }
        });
        JButton cancelButton = new JButton(LNG.get((String)"PRJ_CANCEL"));
        panel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTypeChangeDialog.this.dialog.close();
            }
        });
        JComponent[] allButtons = new JButton[]{this.defaultButton, cancelButton};
        ClientUtilities.adjustEqualSizes(allButtons);
        return panel;
    }

    protected String getTitle() {
        return LNG.get((String)"PRJ_PROJECT_FILE_CHANGE_TYPE_TITLE");
    }

    private ProjectFileType getNewType() {
        String code = this.fileTypeList.getSelectedTypeCode();
        return ProjectFileType.getFileType((String)code);
    }

    private void changeType() {
        ProjectFileType newType = this.getNewType();
        ChangeFileTypeTask.runTask(this.dialog, this.file, newType);
        this.dialog.close();
    }

    private String buildLocalization() {
        String path = "[" + this.project.getName() + "]: ";
        String[] filePath = this.file.getPath();
        for (int i = 1; i < filePath.length - 1; ++i) {
            path = path + filePath[i] + "/";
        }
        return path;
    }

    private FileTypeChangeDialog(Window owner, CommonClientProject project, ClientProjectFile file) {
        this.owner = owner;
        this.project = project;
        this.file = file;
        this.dialog = this.makeDialog();
        this.dialog.setVisible(true);
    }
}

