/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.actions.core.FileExchangerAction;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeState;
import java.awt.Component;
import java.util.ArrayList;
import tecgraf.javautils.gui.StandardDialogs;

public class DeleteAction
extends FileExchangerAction {
    public DeleteAction(FileExchanger fileExchanger) {
        super(fileExchanger, ApplicationImages.ICON_DELETE_16);
    }

    @Override
    public void actionDone() {
        FileExchanger fileExchanger = (FileExchanger)this.getApplication();
        ApplicationFrame frame = fileExchanger.getApplicationFrame();
        ArrayList<Exchange> sels = fileExchanger.getSelectedExchangeList();
        if (sels.size() == 0) {
            String title = ((FileExchanger)this.getApplication()).getName();
            String err = this.getClassString("no.selection.error", new Object[0]);
            StandardDialogs.showErrorDialog((Component)frame, (String)title, (String)err);
            return;
        }
        int nsels = 0;
        for (Exchange sel : sels) {
            ExchangeState state = sel.getState();
            if (state == ExchangeState.RUNNING) continue;
            ++nsels;
            fileExchanger.delFromExchangeList(sel);
        }
        if (sels.size() != nsels) {
            String err = this.getClassString("no.selection.running.error", new Object[0]);
            StandardDialogs.showErrorDialog((Component)frame, (String)((FileExchanger)this.getApplication()).getName(), (String)err);
        }
    }
}

