/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import csbase.client.applicationmanager.ApplicationException;
import csbase.exception.ParseException;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FileTypeColorManager {
    private static final Color UNKNOWN_FILE_TYPE_COLOR = Color.BLACK;
    private static FileTypeColorManager instance;
    private final Map<String, Color> colorsByFileType = new HashMap<String, Color>();

    private FileTypeColorManager(List<String> fileTypes, List<String> rgbs) throws ParseException, ApplicationException {
        if (fileTypes == null) {
            throw new ApplicationException("Par\u00e2metro fileTypes n\u00e3o pode ser nulo!");
        }
        if (rgbs == null) {
            throw new ApplicationException("Par\u00e2metro rgbs n\u00e3o pode ser nulo!");
        }
        if (fileTypes.size() != rgbs.size()) {
            throw new ApplicationException("Configura\u00e7\u00e3o de cores inv\u00e1lida!");
        }
        for (int i = 0; i < fileTypes.size(); ++i) {
            String fileType = fileTypes.get(i);
            Color color = this.stringToColor(rgbs.get(i));
            this.colorsByFileType.put(fileType, color);
        }
    }

    public static FileTypeColorManager getInstance() {
        return instance;
    }

    private Color stringToColor(String txt) throws ParseException {
        if (txt == null) {
            throw new ParseException("Texto que representa a cor est\u00e1 nulo!");
        }
        try {
            String str = txt.trim();
            String c = str.charAt(0) == '#' ? str.substring(1) : str;
            int colvalue = Integer.parseInt(c, 16);
            return new Color(colvalue);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Erro ao converter cor: ", (Throwable)e);
        }
    }

    public static void createInstance(List<String> fileTypes, List<String> rgbs) throws ParseException, ApplicationException {
        if (instance == null) {
            instance = new FileTypeColorManager(fileTypes, rgbs);
        }
    }

    public Color getColor(String fileType) {
        Color color = this.colorsByFileType.get(fileType);
        if (color == null) {
            color = UNKNOWN_FILE_TYPE_COLOR;
        }
        return color;
    }
}

