/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import tecgraf.vix.TypeVS;
import tecgraf.vix.VO;

public class GraphString
extends VO {
    private static final int DEFAULT_BOTTOM_PADDING = 1;
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final Font DEFAULT_FONT = new Font("SansSerif", 1, 12);
    private static final int DEFAULT_LEFT_PADDING = 1;
    private static final int DEFAULT_RIGHT_PADDING = 1;
    private static final int DEFAULT_TOP_PADDING = 1;
    private static final String ETC = "...";
    private static final double NIL = Double.NEGATIVE_INFINITY;
    private double bottomPadding;
    private double centerX;
    private double centerY;
    private Color color;
    private Font font;
    private double height;
    private double leftPadding;
    private double maxWidth;
    private double rightPadding;
    private String text;
    private double topPadding;
    private String visualText;
    private double width;
    private double x0;
    private double y0;

    public GraphString(TypeVS vs, String text) {
        this(vs, text, DEFAULT_FONT);
    }

    public GraphString(TypeVS vs, String text, Font font) {
        this.changeVS(null, vs);
        this.visualText = this.text = text;
        this.bottomPadding = 1.0;
        this.color = DEFAULT_COLOR;
        this.font = font != null ? font : DEFAULT_FONT;
        this.leftPadding = 1.0;
        this.maxWidth = Double.POSITIVE_INFINITY;
        this.rightPadding = 1.0;
        this.topPadding = 1.0;
        this.computeMeasures();
    }

    public void callbackRepaint(Graphics2D g) {
        if (this.x0 == Double.NEGATIVE_INFINITY || this.y0 == Double.NEGATIVE_INFINITY || this.width == Double.NEGATIVE_INFINITY || this.height == Double.NEGATIVE_INFINITY) {
            this.computeMeasures();
        }
        g.setColor(this.color);
        this.setGraphicsFont(g);
        g.drawString(this.toString(), (float)this.x0, (float)this.y0);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GraphString)) {
            return false;
        }
        GraphString string = (GraphString)((Object)object);
        return this.text.equals(string.text);
    }

    public double getBottomPadding() {
        return this.bottomPadding;
    }

    public Rectangle2D getBounds2D() {
        Rectangle bounds = new Rectangle();
        if (!(this.x0 != Double.NEGATIVE_INFINITY && this.y0 != Double.NEGATIVE_INFINITY && this.width != Double.NEGATIVE_INFINITY && this.height != Double.NEGATIVE_INFINITY || this.computeMeasures())) {
            bounds.setFrame(0.0, 0.0, 0.0, 0.0);
            return bounds;
        }
        double w = Math.max(this.width, 0.0);
        double h = Math.max(this.height, 0.0);
        bounds.setFrameFromCenter(this.centerX, this.centerY, this.centerX + w / 2.0 + this.rightPadding + this.leftPadding, this.centerY - h / 2.0 - this.bottomPadding - this.topPadding);
        return bounds;
    }

    public double getLeftPadding() {
        return this.leftPadding;
    }

    public double getRightPadding() {
        return this.rightPadding;
    }

    public String getText() {
        return this.text;
    }

    public double getTopPadding() {
        return this.topPadding;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public void setBottomPadding(double bottomPadding) {
        this.bottomPadding = bottomPadding;
    }

    public void setColor(Color color) {
        this.color = color != null ? color : DEFAULT_COLOR;
    }

    public void setFont(Font font) {
        this.font = font != null ? font : DEFAULT_FONT;
        this.computeMeasures();
    }

    public Font getFont() {
        return this.font;
    }

    public void setLeftPadding(double leftPadding) {
        this.leftPadding = leftPadding;
    }

    public void setLocation(double centerX, double centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.computeMeasures();
    }

    public void setMaxWidth(double maxWidth) {
        this.maxWidth = maxWidth > 0.0 ? maxWidth - this.leftPadding - this.rightPadding : Double.POSITIVE_INFINITY;
        this.computeMeasures();
    }

    public void setRightPadding(double rightPadding) {
        this.rightPadding = rightPadding;
    }

    public void setText(String text) {
        this.visualText = this.text = text;
    }

    public void setTopPadding(double topPadding) {
        this.topPadding = topPadding;
    }

    public String toString() {
        return this.visualText;
    }

    private boolean computeMeasures() {
        this.visualText = this.text;
        Graphics2D g2D = this.vs.getGraphics2D();
        if (g2D != null) {
            this.setGraphicsFont(g2D);
            FontMetrics fontMetrics = g2D.getFontMetrics(this.font);
            Rectangle2D bounds = fontMetrics.getStringBounds(this.visualText, g2D);
            this.width = bounds.getWidth();
            double maxTextWidth = this.maxWidth;
            if (this.width > maxTextWidth) {
                Rectangle2D etcBounds = fontMetrics.getStringBounds(ETC, g2D);
                maxTextWidth -= etcBounds.getWidth();
                while (this.width > maxTextWidth) {
                    this.visualText = this.visualText.substring(0, this.visualText.length() - 1);
                    bounds = fontMetrics.getStringBounds(this.visualText, g2D);
                    this.width = bounds.getWidth();
                }
                this.visualText = this.visualText + ETC;
                this.width += etcBounds.getWidth();
            }
            this.height = bounds.getHeight();
            this.x0 = this.centerX;
            if (this.width > 0.0) {
                this.x0 -= this.width / 2.0;
            }
            this.y0 = this.centerY;
            if (this.height > 0.0) {
                this.y0 += this.height / 4.0;
            }
            return true;
        }
        this.height = Double.NEGATIVE_INFINITY;
        this.width = Double.NEGATIVE_INFINITY;
        this.y0 = Double.NEGATIVE_INFINITY;
        this.x0 = Double.NEGATIVE_INFINITY;
        return false;
    }

    private void setGraphicsFont(Graphics2D g) {
        g.setFont(this.font);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

