/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui.log.actions;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.event.EventListener;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.actions.core.AbstractLogFileAction;
import javax.swing.JComponent;

public class IncPageAction
extends AbstractLogFileAction {
    public IncPageAction(LogPanel logPanel) {
        super(logPanel, ApplicationImages.ICON_PAGE_INC_16);
        logPanel.addPagingEventListener(new EventListener<LogPanel.PagingEvent>(){

            @Override
            public void eventFired(LogPanel.PagingEvent event) {
                long page = event.getPageNumber();
                long pagesCount = event.countPages();
                if (pagesCount <= page) {
                    IncPageAction.this.setEnabled(false);
                } else {
                    IncPageAction.this.setEnabled(true);
                }
            }
        });
    }

    @Override
    public void actionDone(JComponent component) throws Exception {
        long page = this.getLogPanel().getPageNumber();
        long nextPage = page + 1L;
        this.getLogPanel().goToPage(nextPage);
        if (this.getLogPanel().countPages() == nextPage) {
            this.getLogPanel().getTextArea().goToTail();
        }
    }
}

