/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.tasks;

import csbase.client.algorithms.tasks.OutdatedFlowInfo;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.Node;
import csbase.remote.ClientRemoteLocator;
import java.util.ArrayList;
import java.util.Vector;

public class OutdatedFlowTask
extends RemoteTask<Vector<OutdatedFlowInfo>> {
    protected void performTask() throws Exception {
        AlgorithmInfo[] infos;
        Vector<OutdatedFlowInfo> outdated = new Vector<OutdatedFlowInfo>();
        for (AlgorithmInfo info : infos = ClientRemoteLocator.algorithmService.getAllInfo()) {
            OutdatedFlowInfo outInfo = this.isOutdated(info);
            if (outInfo == null) continue;
            outdated.add(outInfo);
        }
        this.setResult(outdated);
    }

    protected OutdatedFlowInfo isOutdated(AlgorithmInfo info) {
        AlgorithmVersionInfo version = info.getLastVersion();
        if (version == null) {
            return null;
        }
        if (version.getType() == AlgorithmConfigurator.ConfiguratorType.SIMPLE) {
            return null;
        }
        try {
            FlowAlgorithmConfigurator configurator = (FlowAlgorithmConfigurator)ClientRemoteLocator.algorithmService.createAlgorithmConfigurator(info.getName(), version.getId());
            ArrayList<AlgorithmInfo> lastVersionNodes = new ArrayList<AlgorithmInfo>();
            ArrayList<AlgorithmVersionInfo> outdatedVersionNodes = new ArrayList<AlgorithmVersionInfo>();
            for (Node node : configurator.getNodes()) {
                String name = node.getConfigurator().getAlgorithmName();
                AlgorithmVersionInfo lastVersion = ClientRemoteLocator.algorithmService.getInfo(name).getLastVersion();
                AlgorithmVersionInfo nodeVersion = node.getConfigurator().getAlgorithmVersion();
                if (nodeVersion.equals((Object)lastVersion)) continue;
                lastVersionNodes.add(ClientRemoteLocator.algorithmService.getInfo(name));
                outdatedVersionNodes.add(nodeVersion);
            }
            if (lastVersionNodes.size() > 0) {
                OutdatedFlowInfo outInfo = new OutdatedFlowInfo(info, lastVersionNodes, outdatedVersionNodes, null);
                return outInfo;
            }
            return null;
        }
        catch (Exception e) {
            OutdatedFlowInfo outInfo = new OutdatedFlowInfo(info, null, null, e);
            return outInfo;
        }
    }
}

