/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationManagerListener;
import csbase.client.applications.Application;
import csbase.client.desktop.DesktopComponentFrame;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;

public class ApplicationFrame
extends DesktopComponentFrame
implements ApplicationManagerListener {
    private final Application application;
    private String title = "";

    void addApplicationManagerListener() {
        if (this.showInstanceId()) {
            ApplicationManager mng = ApplicationManager.getInstance();
            mng.addListener(this);
        }
    }

    @Override
    public void applicationEnded(String id) {
        this.updateTitle(id);
    }

    @Override
    public void applicationStarted(String id) {
        this.updateTitle(id);
    }

    void delApplicationManagerListener() {
        if (this.showInstanceId()) {
            ApplicationManager mng = ApplicationManager.getInstance();
            mng.delListener(this);
        }
    }

    @Override
    public final String getTitle() {
        if (!this.showInstanceId()) {
            return super.getTitle();
        }
        return this.title;
    }

    @Override
    public final void setTitle(String newTitle) {
        if (!this.showInstanceId()) {
            super.setTitle(newTitle);
            return;
        }
        if (this.application == null) {
            super.setTitle(newTitle);
            return;
        }
        String t = newTitle == null ? "" : newTitle;
        int id = this.application.getInstanceIndex();
        super.setTitle(t + " -  [" + id + "]");
        this.title = t;
    }

    private boolean showInstanceId() {
        try {
            ConfigurationManager cnfManager = ConfigurationManager.getInstance();
            Configuration cnf = cnfManager.getConfiguration(this.getClass());
            boolean result = cnf.getOptionalBooleanProperty("show.instance.id", false);
            return result;
        }
        catch (ConfigurationManagerException e) {
            return false;
        }
    }

    @Override
    public final void close() {
        this.delApplicationManagerListener();
        super.close();
    }

    private void updateTitle(String id) {
        if (this.application == null) {
            return;
        }
        String myId = this.application.getId();
        if (myId.equals(id)) {
            this.setTitle(this.title);
        }
    }

    public ApplicationFrame(Application application, String id) {
        this.application = application;
    }
}

