/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.core;

import csbase.client.applications.algorithmsmanager.report.core.BasicTestDialog;
import csbase.client.applications.algorithmsmanager.report.core.ISubjectFactory;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.client.applications.algorithmsmanager.report.core.ITestResult;
import csbase.client.applications.algorithmsmanager.report.core.ReportPanel;
import csbase.client.applications.algorithmsmanager.report.core.SourceListener;
import csbase.client.applications.algorithmsmanager.report.core.TestRunner;
import csbase.client.applications.algorithmsmanager.report.core.TestSelectionPanel;
import csdk.v1_0.helper.application.ApplicationImages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import tecgraf.javautils.gui.GBC;

public class TestDialog
extends BasicTestDialog
implements SourceListener {
    List<ITest<?>> tests;
    ISubjectFactory factory;
    TestSelectionPanel selectionPanel;
    JButton runButton;
    ReportPanel reportPanel;
    JButton closeButton;
    JLabel updateMessage;

    public TestDialog(List<ITest<?>> tests, ISubjectFactory factory, Locale locale, Window owner) {
        super(locale, owner);
        this.setTitle(this.getString("title"));
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.tests = tests;
        this.factory = factory;
        this.closeButton = new JButton(this.getString("close.button"));
        this.closeButton.addActionListener(e -> this.closeDialog());
        this.selectionPanel = new TestSelectionPanel(tests);
        this.selectionPanel.addItemListener(e -> this.runButton.setEnabled(true));
        this.reportPanel = new ReportPanel(locale);
        this.runButton = new JButton(this.getString("run.button"));
        this.runButton.addActionListener(e -> this.runTests());
        this.updateMessage = new JLabel("<html></html>");
        Font titleFont = new Font("SansSerif", 1, 16);
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)this.selectionPanel, new GBC(0, 0).none().insets(9, 12, 6, 12).west().gridwidth(2));
        topPanel.add((Component)this.updateMessage, new GBC(0, 1).horizontal().insets(3, 6, 6, 6));
        topPanel.add((Component)this.runButton, new GBC(1, 1).none().east().insets(6, 6, 6, 6));
        topPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.getString("tests.title")));
        this.reportPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.getString("results.title")));
        ((TitledBorder)topPanel.getBorder()).setTitleFont(titleFont);
        ((TitledBorder)this.reportPanel.getBorder()).setTitleFont(titleFont);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)topPanel, new GBC(0, 0).horizontal().insets(12, 12, 5, 12));
        container.add((Component)new JSeparator(), new GBC(0, 1).horizontal().insets(12, 12, 5, 12));
        container.add((Component)this.reportPanel, new GBC(0, 2).both().insets(5, 12, 5, 12));
        container.add((Component)this.closeButton, new GBC(0, 3).none().east().insets(5, 12, 12, 12));
        this.pack();
        this.addEscListener();
        this.setLocationRelativeTo(owner);
        factory.addListener(this);
    }

    private void writeUpdateMessage() {
        String text = this.getString("new.sources.label");
        this.updateMessage.setForeground(Color.RED);
        this.updateMessage.setText(text);
        this.updateMessage.setIcon(ApplicationImages.ICON_WARNING_16);
        this.runButton.setEnabled(true);
    }

    private void clearUpdateMessage() {
        this.updateMessage.setText("<html></html>");
        this.updateMessage.setIcon(null);
        this.runButton.setEnabled(false);
    }

    private void runTests() {
        List<ITest<?>> selectedTests = this.selectionPanel.getSelection();
        if (selectedTests == null || selectedTests.size() == 0) {
            return;
        }
        TestRunner testRunner = new TestRunner(this.factory, this, this.getString("running.algorithms.tests.title"), this.getString("running.algorithms.tests.message"));
        Map<ITest<?>, ITestResult<?>> map = testRunner.run(selectedTests);
        this.reportPanel.updateContent(map);
        this.clearUpdateMessage();
    }

    private void addEscListener() {
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestDialog.this.closeDialog();
            }
        };
        boolean mode = true;
        InputMap inputMap = this.rootPane.getInputMap(1);
        ActionMap actionMap = this.rootPane.getActionMap();
        int esc = 27;
        KeyStroke cancelStroke = KeyStroke.getKeyStroke(27, 0);
        String actionMapKey = cancelStroke.toString();
        inputMap.put(cancelStroke, actionMapKey);
    }

    private void closeDialog() {
        this.factory.removeListener(this);
        this.dispose();
    }

    @Override
    public void sourceChanged() {
        this.writeUpdateMessage();
    }
}

