/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractVersionTreeNodeAction;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.remote.srvproxies.PlatformProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.Platform;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;

public class AddPlatform
extends AbstractVersionTreeNodeAction {
    private AlgorithmVersionInfo version;

    public AddPlatform(VersionTree tree, AlgorithmVersionInfo version) {
        super(tree, LNG.get((String)"algomanager.menu.platform.add"));
        this.version = version;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new AddPlatformDialog().show();
    }

    private class AddPlatformDialog {
        private DesktopComponentDialog mainDialog;
        private String dialogTitle;
        private String includedPlatform;
        Vector<String> candidatePlatforms;

        public AddPlatformDialog() {
            this.dialogTitle = MessageFormat.format(LNG.get((String)"algomanager.title.include_platform"), AddPlatform.this.version.getInfo().getId(), AddPlatform.this.version.getId());
            Vector platforms = AddPlatform.this.version.getSupportedPlatforms();
            Collections.sort(platforms);
            this.candidatePlatforms = this.getCandidatePlatforms(platforms);
        }

        private Vector<String> getCandidatePlatforms(Vector<String> platforms) {
            String taskTitle = LNG.get((String)"algomanager.title");
            Vector<Platform> allPlatforms = PlatformProxy.getAllPlatforms(this.mainDialog, taskTitle, LNG.get((String)"algomanager.msg.waiting_platforms"));
            if (allPlatforms.size() == 0) {
                StandardErrorDialogs.showErrorDialog((Window)this.mainDialog, this.dialogTitle, LNG.get((String)"algomanager.error.no_platforms"));
                return null;
            }
            Vector<String> candidates = new Vector<String>();
            for (int i = 0; i < allPlatforms.size(); ++i) {
                Platform plat = allPlatforms.get(i);
                String platName = (String)plat.getId();
                if (platforms.contains(platName)) continue;
                candidates.add(platName);
            }
            Collections.sort(candidates);
            return candidates;
        }

        public String show() {
            if (this.candidatePlatforms == null) {
                return null;
            }
            if (this.candidatePlatforms.size() == 0) {
                StandardErrorDialogs.showErrorDialog(AddPlatform.this.getWindow(), this.dialogTitle, LNG.get((String)"algomanager.error.no_more_platforms"));
                return null;
            }
            String includeTitle = MessageFormat.format(this.dialogTitle, AddPlatform.this.version.getInfo().getName(), AddPlatform.this.version.getId());
            final DesktopComponentDialog dialog = new DesktopComponentDialog(AddPlatform.this.getWindow());
            dialog.setTitle(includeTitle);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    dialog.close();
                }
            });
            JComboBox<String> platCombo = new JComboBox<String>(this.candidatePlatforms);
            JComponent[][] info = new JComponent[][]{{new JLabel(LNG.get((String)"algomanager.label.platform")), platCombo}};
            JPanel infoPanel = GUIUtils.createBasicGridPanel((JComponent[][])info);
            JPanel buttonsPanel = new JPanel();
            JButton includeButton = new JButton(LNG.get((String)"algomanager.button.include"));
            includeButton.addActionListener(e -> {
                String platform = (String)platCombo.getSelectedItem();
                this.includedPlatform = this.addPlatform(platform, dialog, includeTitle) ? platform : null;
                dialog.close();
            });
            JButton cancelButton = new JButton(LNG.get((String)"algomanager.button.cancel"));
            cancelButton.addActionListener(e -> {
                this.includedPlatform = null;
                dialog.close();
            });
            ClientUtilities.adjustEqualSizes(includeButton, cancelButton);
            buttonsPanel.add(includeButton);
            buttonsPanel.add(cancelButton);
            Container cp = dialog.getContentPane();
            cp.add((Component)infoPanel, "Center");
            cp.add((Component)buttonsPanel, "South");
            dialog.pack();
            dialog.center(AddPlatform.this.getWindow());
            dialog.setVisible(true);
            return this.includedPlatform;
        }

        private boolean addPlatform(String platform, DesktopComponentDialog dialog, String dialogTitle) {
            AlgorithmInfo algo = AlgorithmManagementProxy.includePlatform(AddPlatform.this.version.getInfo().getId(), AddPlatform.this.version.getId(), platform, dialog);
            if (algo == null) {
                StandardErrorDialogs.showErrorDialog((Window)dialog, LNG.get((String)"algomanager.title.error") + " - " + dialogTitle, MessageFormat.format(LNG.get((String)"algomanager.error.platform_include"), platform));
                return false;
            }
            return true;
        }
    }
}

