/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractVersionTreeNodeAction;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class RemoveReleaseNotesFile
extends AbstractVersionTreeNodeAction {
    private final AlgorithmVersionInfo version;
    private final FileInfo[] files;

    public RemoveReleaseNotesFile(VersionTree tree, AlgorithmVersionInfo version, FileInfo[] files) {
        super(tree, LNG.get((String)"algomanager.menu.release.notes.remove"));
        this.version = version;
        this.files = files;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.removeFile();
    }

    private void removeFile() {
        new RemoveFileDialog().show();
    }

    private class RemoveFileDialog {
        private RemoveFileDialog() {
        }

        public void show() {
            String removeTitle = LNG.get((String)"algomanager.title.remove_release_notes");
            Object[] options = new Object[]{LNG.get((String)"algomanager.button.remove"), LNG.get((String)"algomanager.button.cancel")};
            int opt = StandardDialogs.showOptionDialog((Component)RemoveReleaseNotesFile.this.getWindow(), (String)removeTitle, (Object)LNG.get((String)"algomanager.msg.confirm.release_notes.remove"), (Object[])options);
            if (opt != 0) {
                return;
            }
            boolean success = AlgorithmManagementProxy.removeReleaseNotesFiles(RemoveReleaseNotesFile.this.version, RemoveReleaseNotesFile.this.files, RemoveReleaseNotesFile.this.getWindow());
            if (!success) {
                StandardErrorDialogs.showErrorDialog(RemoveReleaseNotesFile.this.getWindow(), LNG.get((String)"algomanager.title.error") + " - " + removeTitle, LNG.get((String)"algomanager.error.release_notes.remove"));
            }
        }
    }
}

