/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.csvviewer.actions;

import csbase.client.applications.ApplicationAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.csvviewer.CSVViewer;
import csbase.client.util.StandardErrorDialogs;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class AbstractCSVAction
extends ApplicationAction<CSVViewer> {
    protected static final String TAG_NAME = "name";
    protected static final String TAG_MNEMONIC = "mnemonic";
    protected static final String TAG_TOOLTIP = "tooltip";

    protected AbstractCSVAction(CSVViewer application, ImageIcon icon) {
        this(application);
        this.putValue("SmallIcon", icon);
    }

    protected AbstractCSVAction(CSVViewer application) {
        super(application);
        String tooltip;
        Integer mnemonic;
        String name = this.getName();
        if (name != null) {
            this.putValue("Name", name);
        }
        if ((mnemonic = this.getMnemonic()) != null) {
            this.putValue("MnemonicKey", mnemonic);
        }
        if ((tooltip = this.getToolTipText()) != null) {
            this.putValue("ShortDescription", tooltip);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            JComponent cmp = (JComponent)ae.getSource();
            this.actionDone(cmp);
        }
        catch (Exception e) {
            ApplicationFrame window = ((CSVViewer)this.getApplication()).getApplicationFrame();
            String title = ((CSVViewer)this.getApplication()).getName();
            StandardErrorDialogs.showErrorDialog((Window)window, title, (Throwable)e);
        }
    }

    public final String getName() {
        return ((CSVViewer)this.getApplication()).getString(this.getClass().getSimpleName() + "." + TAG_NAME);
    }

    public final String getToolTipText() {
        return ((CSVViewer)this.getApplication()).getString(this.getClass().getSimpleName() + "." + TAG_TOOLTIP);
    }

    private final Integer getMnemonic() {
        String mn = ((CSVViewer)this.getApplication()).getString(this.getClass().getSimpleName() + "." + TAG_MNEMONIC);
        if (mn == null || "".equals(mn)) {
            return null;
        }
        return mn.charAt(0);
    }

    public abstract void actionDone(JComponent var1) throws Exception;
}

