/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransfer;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.filetransfer.ProjectFileSelectorPanel;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectTree;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.gui.MultiImageButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIResources;

public class FileTransfer
extends Application {
    private ProjectFileSelectorPanel sourceFilePanel;
    private ProjectFileSelectorPanel targetFilePanel;

    public FileTransfer(String id) {
        super(id);
        this.createMainFrame();
        this.showFrame();
    }

    @Override
    public void killApplication() {
        this.sourceFilePanel.removeObservers();
        this.targetFilePanel.removeObservers();
    }

    @Override
    public boolean userCanKillApplication() {
        return true;
    }

    private void showFrame() {
        this.getApplicationFrame().setSize(new Dimension(800, 600));
        this.getApplicationFrame().center(DesktopFrame.getInstance().getDesktopFrame());
        this.getApplicationFrame().setVisible(true);
    }

    private void createMainFrame() {
        Container cp = this.getApplicationFrame().getContentPane();
        cp.setLayout(new GridBagLayout());
        cp.add((Component)this.createTextPanel(), new GBC(0, 0).horizontal().north().insets(10, 10, 0, 10));
        cp.add((Component)this.createTransferPanel(), new GBC(0, 1).both().center().insets(10, 11, 0, 10));
        cp.add((Component)this.createButtonPanel(), new GBC(0, 2).horizontal().center().insets(10, 10, 5, 10));
    }

    private JPanel createTransferPanel() {
        JPanel tp = new JPanel(new GridBagLayout());
        try {
            this.sourceFilePanel = new ProjectFileSelectorPanel(this, true, this.getString("project.source.label"), false, new String[0]);
            tp.add((Component)this.sourceFilePanel, new GBC(0, 0).both().northwest().insets(0, 0, 0, 0));
            tp.add((Component)this.createActionButtonsPanel(), new GBC(1, 0).fillx().center().insets(0, 10, 0, 10));
            this.targetFilePanel = new ProjectFileSelectorPanel(this, false, this.getString("project.target.label"), false, new String[0]);
            tp.add((Component)this.targetFilePanel, new GBC(2, 0).both().northeast().insets(0, 0, 0, 0));
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.getApplicationFrame(), this.getApplicationFrame().getTitle(), (Throwable)e);
        }
        return tp;
    }

    private JPanel createButtonPanel() {
        JButton exitButton = new JButton(new ApplicationExitAction(this));
        JPanel bp = new JPanel(new FlowLayout());
        bp.add(exitButton);
        return bp;
    }

    private JPanel createTextPanel() {
        JPanel tp = new JPanel(new GridBagLayout());
        tp.setForeground(Color.GRAY);
        JLabel icon = new JLabel(ApplicationImages.ICON_INFORMATION_32);
        JLabel lb1 = new JLabel(this.getString("move.text"));
        JLabel lb2 = new JLabel(this.getString("copy.text"));
        lb1.setForeground(Color.GRAY);
        lb2.setForeground(Color.GRAY);
        tp.add((Component)icon, new GBC(0, 0).height(2).none().insets(0, 0, 0, 5));
        tp.add((Component)lb1, new GBC(1, 0).horizontal().northwest());
        tp.add((Component)lb2, new GBC(1, 1).horizontal().northwest());
        return tp;
    }

    private JComponent createActionButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        MultiImageButton moveRightButton = new MultiImageButton(null, this.getString("button.move"), GUIResources.SELECTOR_ADD_ICON);
        moveRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransfer.this.moveFiles(FileTransfer.this.sourceFilePanel.getProjectTree(), FileTransfer.this.targetFilePanel.getProjectTree());
            }
        });
        MultiImageButton copyRightButton = new MultiImageButton(null, this.getString("button.copy"), GUIResources.SELECTOR_ADD_ICON);
        copyRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransfer.this.copyFiles(FileTransfer.this.sourceFilePanel.getProjectTree(), FileTransfer.this.targetFilePanel.getProjectTree());
            }
        });
        MultiImageButton moveLeftButton = new MultiImageButton(GUIResources.SELECTOR_REMOVE_ICON, this.getString("button.move"), null);
        moveLeftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransfer.this.moveFiles(FileTransfer.this.targetFilePanel.getProjectTree(), FileTransfer.this.sourceFilePanel.getProjectTree());
            }
        });
        MultiImageButton copyLeftButton = new MultiImageButton(GUIResources.SELECTOR_REMOVE_ICON, this.getString("button.copy"), null);
        copyLeftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransfer.this.copyFiles(FileTransfer.this.targetFilePanel.getProjectTree(), FileTransfer.this.sourceFilePanel.getProjectTree());
            }
        });
        buttonsPanel.add((Component)moveRightButton, new GBC(0, 0).fillx().center());
        buttonsPanel.add((Component)copyRightButton, new GBC(0, 1).fillx().center().insets(5, 0, 0, 0));
        buttonsPanel.add((Component)moveLeftButton, new GBC(0, 2).fillx().center().insets(30, 0, 0, 0));
        buttonsPanel.add((Component)copyLeftButton, new GBC(0, 3).fillx().center().insets(5, 0, 0, 0));
        return buttonsPanel;
    }

    private void copyFiles(ProjectTree source, ProjectTree target) {
        if (this.canTransfer(source, target)) {
            source.startCopyAction();
            target.startPasteAction();
        }
    }

    private void moveFiles(ProjectTree source, ProjectTree target) {
        if (this.canTransfer(source, target)) {
            source.startCutAction();
            target.startPasteAction();
        }
    }

    private boolean canTransfer(ProjectTree source, ProjectTree target) {
        if (source.getSelectionCount() == 0) {
            StandardErrorDialogs.showErrorDialog((Window)this.getApplicationFrame(), this.getApplicationFrame().getTitle(), this.getString("missing.source.msg"));
            return false;
        }
        if (target.getSelectionCount() == 1 && target.getSelectedFile().isDirectory()) {
            return true;
        }
        StandardErrorDialogs.showErrorDialog((Window)this.getApplicationFrame(), this.getApplicationFrame().getTitle(), this.getString("missing.target.msg"));
        return false;
    }
}

