/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.monitor;

import csbase.client.applications.ApplicationComponentPanel;
import csbase.client.applications.serverdiagnostic.ServerDiagnostic;
import csbase.client.applications.serverdiagnostic.monitor.DefaultSwingRenderer;
import csbase.client.applications.serverdiagnostic.monitor.DiskRenderer;
import csbase.client.applications.serverdiagnostic.monitor.StatusGroupTreeNode;
import csbase.client.applications.serverdiagnostic.monitor.StatusListPanel;
import csbase.logic.diagnosticservice.Status;
import java.awt.Component;
import java.awt.GridBagLayout;
import tecgraf.javautils.gui.GBC;

public class MonitorPanel
extends ApplicationComponentPanel<ServerDiagnostic> {
    Status busStatus;
    Status CSFSStatus;
    Status[] publishedServicesStatus;
    Status diskStatus;
    StatusListPanel statusPanel;

    public MonitorPanel(ServerDiagnostic application, Status busStatus, Status[] publishedServicesStatus, Status CSFSStatus, Status diskStatus) {
        super(application);
        this.busStatus = busStatus;
        this.publishedServicesStatus = publishedServicesStatus;
        this.CSFSStatus = CSFSStatus;
        this.diskStatus = diskStatus;
        this.buildInterface();
    }

    private void buildInterface() {
        DefaultSwingRenderer defaultRenderer = new DefaultSwingRenderer();
        StatusGroupTreeNode statusTree = new StatusGroupTreeNode("root");
        if (this.busStatus != null) {
            StatusGroupTreeNode openbusGroupNode = statusTree.addStatusGroup(this.getString("openbus.group.label"));
            this.busStatus.setName(this.getString("openbus.conection.label"));
            openbusGroupNode.addStatus(this.busStatus, defaultRenderer);
            if (this.publishedServicesStatus != null && this.publishedServicesStatus.length > 0) {
                StatusGroupTreeNode publishedGroupNode = openbusGroupNode.addStatusGroup(this.getString("published.offers.label"));
                for (Status status : this.publishedServicesStatus) {
                    publishedGroupNode.addStatus(status, defaultRenderer);
                }
            }
        }
        if (this.CSFSStatus != null) {
            this.CSFSStatus.setName(this.getString("csfs.conection.label"));
            statusTree.addStatusGroup(this.getString("csfs.group.label")).addStatus(this.CSFSStatus, defaultRenderer);
        }
        if (this.diskStatus != null) {
            this.diskStatus.setName(this.getString("disk.occupation.label"));
            statusTree.addStatusGroup(this.getString("disk.group.label")).addStatus(this.diskStatus, new DiskRenderer());
        }
        this.statusPanel = new StatusListPanel((ServerDiagnostic)this.getApplication(), statusTree);
        this.statusPanel.refreshPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.statusPanel, new GBC(0, 0).both().insets(5, 5, 5, 5));
    }
}

