/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v2.application;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.csdk.ICSDKContextFactory;
import csbase.client.csdk.v2.core.CSDKEnvironment;
import csbase.logic.applicationservice.ApplicationRegistry;
import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IApplication;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.api.core.IContext;
import csdk.v2.helper.application.Message;
import csdk.v2.helper.application.MessageSender;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public class CSDKApplication
extends ApplicationType {
    private IApplication application;
    private CSDKEnvironment csdkEnv;

    public CSDKApplication(ApplicationRegistry registry, Class<? extends IApplication> appClass) throws csbase.client.applicationmanager.ApplicationException {
        super(registry.getId());
        this.csdkEnv = this.createCSDKEnvironment(registry, appClass);
        this.application = this.createApplicationClassInstance(registry, appClass);
    }

    private CSDKEnvironment createCSDKEnvironment(ApplicationRegistry registry, Class<? extends IApplication> appClass) throws csbase.client.applicationmanager.ApplicationException {
        Client client = Client.getInstance();
        ICSDKContextFactory csdkContextFactory = client.getCSDKContextFactory();
        Map<Class<? extends IContext>, IContext> contexts = csdkContextFactory.createCSDKv2Contexts(this.getInstanceId(), appClass, registry);
        if (contexts == null || contexts.isEmpty() || !contexts.containsKey(IApplicationContext.class)) {
            throw new csbase.client.applicationmanager.ApplicationException("A f\u00e1brica de contextos precisa pelo menos criar o contexto obrigat\u00f3rio " + IApplicationContext.class.getSimpleName());
        }
        return new CSDKEnvironment(contexts);
    }

    private IApplication createApplicationClassInstance(ApplicationRegistry registry, Class<? extends IApplication> appClass) throws csbase.client.applicationmanager.ApplicationException {
        String id = registry.getId();
        try {
            Constructor<? extends IApplication> constructor = appClass.getConstructor(ICSDKEnvironment.class);
            IApplication appInstance = constructor.newInstance(this.csdkEnv);
            IApplication app = appClass.cast(appInstance);
            return app;
        }
        catch (InvocationTargetException e) {
            Throwable appException = e.getTargetException();
            String message = MessageFormat.format(LNG.get((String)(CSDKApplication.class.getSimpleName() + ".instatiation.exception")), id, appClass.getName(), appException.getLocalizedMessage());
            throw new csbase.client.applicationmanager.ApplicationException(message, appException);
        }
        catch (NoSuchMethodException e) {
            String message = MessageFormat.format(LNG.get((String)(CSDKApplication.class.getSimpleName() + ".no.valid.constructor")), id, appClass.getName());
            throw new csbase.client.applicationmanager.ApplicationException(message, e);
        }
        catch (InstantiationException e) {
            String message = MessageFormat.format(LNG.get((String)(CSDKApplication.class.getSimpleName() + ".no.instantiation")), id, appClass.getName());
            throw new csbase.client.applicationmanager.ApplicationException(message, e);
        }
        catch (IllegalAccessException e) {
            String message = MessageFormat.format(LNG.get((String)(CSDKApplication.class.getSimpleName() + ".application.manager.bad.implementation")), id, appClass.getName());
            throw new csbase.client.applicationmanager.ApplicationException(message, e);
        }
    }

    @Override
    public boolean userCanKillApplication() {
        return this.application.canEndApplication();
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        Message message = new Message(name, value);
        MessageSender sender = null;
        ApplicationManager manager = ApplicationManager.getInstance();
        ApplicationType senderApp = manager.getApplicationInstance(senderId);
        if (senderApp != null) {
            sender = new MessageSender(senderApp.getId(), senderId);
        }
        this.application.onSyncMessageReceived((IMessage)message, sender);
    }

    @Override
    public void killApplication() throws csbase.client.applicationmanager.ApplicationException {
        try {
            this.application.onApplicationEnd();
        }
        catch (ApplicationException e) {
            throw new csbase.client.applicationmanager.ApplicationException(e);
        }
        finally {
            ApplicationManager manager = ApplicationManager.getInstance();
            manager.notifyDeath(this);
            this.csdkEnv.cleanup();
            this.csdkEnv = null;
            this.application = null;
        }
    }

    @Override
    public void startApplication() throws csbase.client.applicationmanager.ApplicationException {
        try {
            this.application.onApplicationStart();
        }
        catch (ApplicationException e) {
            throw new csbase.client.applicationmanager.ApplicationException(e);
        }
    }

    @Override
    public void finishApplication() {
    }

    public IApplication getApplication() {
        return this.application;
    }

    @Override
    protected Class<?> getMainApplicationClass() {
        return this.application.getClass();
    }
}

