/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable.UI;

import csbase.client.facilities.configurabletable.UI.ORIENTATION;
import csbase.client.facilities.configurabletable.UI.Panel4Tables;
import csbase.client.facilities.configurabletable.UI.UI4Tables;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTabbedPane;

public class TabbedPane4Tables
extends JTabbedPane
implements UI4Tables {
    private String id;
    private Map<String, Panel4Tables> panelByTab;

    public TabbedPane4Tables(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id n\u00e3o pode ser nulo.");
        }
        this.id = id;
        this.panelByTab = new LinkedHashMap<String, Panel4Tables>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void addTab(String title, ORIENTATION orientation) {
        this.panelByTab.put(title, new Panel4Tables(this.getId(), orientation));
    }

    public <T> void addTable(String title, ConfigurableTable<?> table, String label, Class<T> dataType) {
        if (!this.isTabExist(title)) {
            throw new IllegalArgumentException("N\u00e3o existe aba com t\u00edtulo: " + title);
        }
        this.panelByTab.get(title).addTable(table, label, dataType);
    }

    private boolean isTabExist(String title) {
        return this.panelByTab.containsKey(title);
    }

    @Override
    public ConfigurableTable<?> getTableById(String tableId) {
        for (Map.Entry<String, Panel4Tables> entry : this.panelByTab.entrySet()) {
            ConfigurableTable<?> table = entry.getValue().getTableById(tableId);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    @Override
    public <T> ConfigurableTable<T> getTableById(String tableId, Class<T> dataType) {
        for (Map.Entry<String, Panel4Tables> entry : this.panelByTab.entrySet()) {
            Panel4Tables panel = entry.getValue();
            ConfigurableTable<T> table = panel.getTableById(tableId, dataType);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    public List<ConfigurableTable<?>> getTablesByTab(String title) {
        if (this.panelByTab.containsKey(title)) {
            return this.panelByTab.get(title).getAllTables();
        }
        return null;
    }

    public <T> List<ConfigurableTable<T>> getTablesByTab(String title, Class<T> dataType) {
        if (this.panelByTab.containsKey(title)) {
            return this.panelByTab.get(title).getAllTables(dataType);
        }
        return null;
    }

    @Override
    public List<ConfigurableTable<?>> getTablesFromSelectedComponent() {
        int selectedTab = this.getSelectedIndex();
        String tabTitle = this.getTitleAt(selectedTab);
        return this.getTablesByTab(tabTitle);
    }

    @Override
    public <T> List<ConfigurableTable<T>> getTablesFromSelectedComponent(Class<T> dataType) {
        int selectedTab = this.getSelectedIndex();
        String tabTitle = this.getTitleAt(selectedTab);
        return this.getTablesByTab(tabTitle, dataType);
    }

    @Override
    public List<ConfigurableTable<?>> getAllTables() {
        ArrayList allTables = new ArrayList();
        for (Map.Entry<String, Panel4Tables> entry : this.panelByTab.entrySet()) {
            allTables.addAll(entry.getValue().getAllTables());
        }
        return allTables;
    }

    @Override
    public <T> List<ConfigurableTable<T>> getAllTables(Class<T> dataType) {
        ArrayList<ConfigurableTable<T>> allTables = new ArrayList<ConfigurableTable<T>>();
        for (Map.Entry<String, Panel4Tables> entry : this.panelByTab.entrySet()) {
            allTables.addAll(entry.getValue().getAllTables(dataType));
        }
        return allTables;
    }

    @Override
    public String getTableLabel(String tableId) {
        for (Map.Entry<String, Panel4Tables> entry : this.panelByTab.entrySet()) {
            String result = entry.getValue().getTableLabel(tableId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void buildUI() {
        this.removeAll();
        for (Map.Entry<String, Panel4Tables> entry : this.panelByTab.entrySet()) {
            String tabTitle = entry.getKey();
            Panel4Tables panel = entry.getValue();
            panel.buildUI();
            this.add(tabTitle, panel);
        }
    }
}

