/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.CommonProjectSelectDialog;
import csbase.client.project.ProjectTree;
import csbase.client.project.action.ProjectCloseAction;
import csbase.logic.CommandStatus;
import csbase.logic.CommonClientProject;
import csbase.logic.UserProjectInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.CommandPersistenceServiceInterface;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class CommonProjectDeleteDialog
extends CommonProjectSelectDialog {
    @Override
    protected void handleAction() {
        if (!this.confirmDeletion()) {
            return;
        }
        CommonClientProject openProject = DesktopFrame.getInstance().getProject();
        ProjectTree tree = DesktopFrame.getInstance().getTree();
        final List<UserProjectInfo> selectedProjects = this.getSelectedProjects();
        for (UserProjectInfo userProjectInfo : selectedProjects) {
            if (openProject == null || !openProject.getId().equals(userProjectInfo.getProjectId())) continue;
            ProjectCloseAction pca = new ProjectCloseAction(tree);
            pca.close();
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                for (UserProjectInfo userProjectInfo : selectedProjects) {
                    CommonClientProject.remove((Object)userProjectInfo.getProjectId());
                }
            }
        };
        String msg = LNG.get((String)"CommonProjectSelectDialog.info.remove.project");
        if (task.execute(this.getOwner(), this.getTitle(), msg)) {
            this.close();
        }
    }

    private boolean confirmDeletion() {
        String title = this.getTitle();
        Window owner = this.getOwner();
        Object[] options = new Object[]{LNG.get((String)"CommonProjectDeleteDialog.delete.button"), LNG.get((String)"CommonProjectDeleteDialog.cancel.button")};
        final List<UserProjectInfo> selectedProjects = this.getSelectedProjects();
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                CommandPersistenceServiceInterface cpsi = ClientRemoteLocator.commandPersistenceService;
                for (UserProjectInfo project : selectedProjects) {
                    Set runningCommands = cpsi.getStatusCommandInfos(project.getProjectId(), Arrays.asList(CommandStatus.FINISHED), false);
                    if (runningCommands.size() <= 0) continue;
                    this.setResult(false);
                    return;
                }
                this.setResult(true);
            }
        };
        String msg = LNG.get((String)"CommonProjectSelectDialog.info.remove.project");
        if (!task.execute(this.getOwner(), this.getTitle(), msg) || !((Boolean)task.getResult()).booleanValue()) {
            msg = LNG.get((String)"CommonProjectSelectDialog.error.running.commands");
            StandardDialogs.showWarningDialog((Component)owner, (String)title, (String)msg);
            return false;
        }
        if (selectedProjects.size() > 1) {
            msg = LNG.get((String)"CommonProjectSelectDialog.info.confirm.removal.n");
        } else {
            UserProjectInfo userProjectInfo = selectedProjects.get(0);
            String fmt = LNG.get((String)"CommonProjectSelectDialog.info.confirm.removal");
            msg = String.format(fmt, userProjectInfo.getProjectName());
        }
        int opt = StandardDialogs.showOptionDialog((Component)owner, (String)title, (Object)msg, (Object[])options);
        return opt == 0;
    }

    public CommonProjectDeleteDialog(Window owner) {
        super(owner, false);
        this.setTitle(LNG.get((String)"CommonProjectSelectDialog.title.delete"));
        this.setDefaultTextButtonText(LNG.get((String)"CommonProjectDeleteDialog.delete.button"));
    }
}

