/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.sga;

import csbase.logic.SharedObject;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SharedObjectServiceInterface;
import java.rmi.RemoteException;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class CommandDescriptionHistory {
    private static final int MAX_DESCRIPTIONS = 10;
    private static final String COMMAND_DESCRIPTION_OBJ = "command_description_history";
    private static final String COMMAND_DESCRIPTION_KEY = "description_";
    private static final String HISTORY_CATEGORY = "History";

    public String[] loadPreviousDescriptions() throws RemoteException {
        SharedObject sharedObject = this.readSharedObject();
        if (sharedObject != null) {
            Deque<String> descriptions = this.sharedObjectContentToHistory(sharedObject.getContents());
            return descriptions.toArray(new String[descriptions.size()]);
        }
        return new String[0];
    }

    private SharedObject readSharedObject() throws RemoteException {
        SharedObjectServiceInterface sharedObjectService = ClientRemoteLocator.sharedObjectService;
        try {
            SharedObject sharedObject = sharedObjectService.getSharedObject(HISTORY_CATEGORY, User.getLoggedUser().getId(), COMMAND_DESCRIPTION_OBJ);
            return sharedObject;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Deque<String> sharedObjectContentToHistory(Object contents) {
        LinkedList<String> descriptions = new LinkedList<String>();
        if (contents != null) {
            Object object;
            Map historyMap = (Map)contents;
            for (int i = 0; i < 10 && (object = historyMap.get(COMMAND_DESCRIPTION_KEY + i)) != null; ++i) {
                descriptions.addLast(object.toString());
            }
        }
        return descriptions;
    }

    private Object historyToSharedObjectContent(Deque<String> history) {
        HashMap<String, String> contents = new HashMap<String, String>();
        for (int i = 0; i < 10 && !history.isEmpty(); ++i) {
            contents.put(COMMAND_DESCRIPTION_KEY + i, history.removeFirst());
        }
        return contents;
    }

    public void saveDescription(String description) throws RemoteException {
        Deque<Object> descriptions;
        if (description == null) {
            return;
        }
        SharedObject sharedObject = this.readSharedObject();
        if (sharedObject != null) {
            descriptions = this.sharedObjectContentToHistory(sharedObject.getContents());
            if (descriptions.contains(description)) {
                descriptions.remove(description);
            }
        } else {
            descriptions = new LinkedList();
            sharedObject = new SharedObject(HISTORY_CATEGORY, User.getLoggedUser().getId(), COMMAND_DESCRIPTION_OBJ, false, null);
        }
        descriptions.addFirst(description);
        Object content = this.historyToSharedObjectContent(descriptions);
        sharedObject.setContents(content);
        SharedObjectServiceInterface sharedObjectService = ClientRemoteLocator.sharedObjectService;
        sharedObjectService.saveSharedObject(sharedObject);
    }
}

