/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.xmlpanel;

import csbase.client.util.xmlpanel.XMLPanelNodeSelectionListener;
import csbase.client.util.xmlpanel.XMLPanelStyleInterface;
import csbase.client.util.xmlpanel.XMLPanelUtils;
import csbase.client.util.xmlpanel.xmlattributetablepanel.XMLAttributeTablePanel;
import csbase.client.util.xmlpanel.xmlsearchpanel.XMLSearchPanel;
import csbase.client.util.xmlpanel.xmltagtreepanel.XMLTagTreePanel;
import csbase.client.util.xmlpanel.xmltextpanel.XMLTextPanel;
import csbase.logic.ClientFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class XMLStandardPanel
extends JPanel {
    private final XMLTagTreePanel treePanel = new XMLTagTreePanel();
    private final XMLAttributeTablePanel attrPanel = new XMLAttributeTablePanel();
    private final XMLTextPanel textPanel = new XMLTextPanel();
    private final XMLSearchPanel searchPanel = new XMLSearchPanel();
    private final JSplitPane horizontalSplit = new JSplitPane(1);
    private final JSplitPane verticalSplit = new JSplitPane(0);
    private ClientFile dtdClientFile;
    private XMLPanelStyleInterface style;

    private void adjustDefaultSplitStatus() {
        this.horizontalSplit.setDividerLocation(0.25);
        if (this.textPanel.isVisible()) {
            this.verticalSplit.setTopComponent(this.attrPanel);
            this.verticalSplit.setBottomComponent(this.textPanel);
            this.horizontalSplit.setRightComponent(this.verticalSplit);
            this.verticalSplit.setDividerLocation(0.7);
        } else {
            this.horizontalSplit.setRightComponent(this.attrPanel);
        }
    }

    public boolean isSearchPanelVisible() {
        return this.searchPanel.isVisible();
    }

    public void refreshAll() {
        this.treePanel.setNode(this.treePanel.getNode());
        this.repaint();
    }

    public void setDTDClientFile(ClientFile dtdClientFile) {
        this.dtdClientFile = dtdClientFile;
    }

    public void setSearchPanelVisible(boolean flag) {
        this.searchPanel.setVisible(flag);
    }

    public void setStyle(XMLPanelStyleInterface style) {
        this.style = style;
        this.treePanel.setStyle(style);
        this.updateFromStyle();
        this.refreshAll();
    }

    private void updateFromStyle() {
        boolean showTextPanel = true;
        if (this.style != null) {
            showTextPanel = this.style.isTextPanelNeeded();
        }
        this.textPanel.setVisible(showTextPanel);
        this.adjustDefaultSplitStatus();
    }

    public XMLPanelStyleInterface getStyle() {
        return this.style;
    }

    public void setXMLClientFile(ClientFile xmlClientFile, EntityResolver resolver, Charset charset) throws Exception {
        EntityResolver er = resolver != null ? resolver : (this.dtdClientFile != null ? new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws IOException {
                InputStream stream = XMLStandardPanel.this.dtdClientFile.getInputStream();
                InputSource is = new InputSource(stream);
                return is;
            }
        } : null);
        final Node node = XMLPanelUtils.getRootNode(xmlClientFile, er, charset);
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                XMLStandardPanel.this.treePanel.setNode(node);
                XMLStandardPanel.this.attrPanel.setNode(node);
                XMLStandardPanel.this.textPanel.setNode(node);
                XMLStandardPanel.this.treePanel.setSelectedNode(node);
                XMLStandardPanel.this.horizontalSplit.setDividerLocation(300);
                XMLStandardPanel.this.verticalSplit.setDividerLocation(300);
            }
        });
    }

    public XMLStandardPanel(String attrTitle, String textTitle) {
        BorderUtil.setTitledBorder((JComponent)this.attrPanel, (String)attrTitle);
        BorderUtil.setTitledBorder((JComponent)this.textPanel, (String)textTitle);
        Dimension minSize = new Dimension(100, 100);
        this.treePanel.setMinimumSize(minSize);
        this.attrPanel.setMinimumSize(minSize);
        this.textPanel.setMinimumSize(minSize);
        Dimension prefSize = new Dimension(200, 200);
        this.treePanel.setPreferredSize(prefSize);
        this.attrPanel.setPreferredSize(prefSize);
        this.textPanel.setPreferredSize(prefSize);
        this.setLayout(new BorderLayout());
        this.verticalSplit.add(this.attrPanel);
        this.verticalSplit.add(this.textPanel);
        this.verticalSplit.setOneTouchExpandable(true);
        this.horizontalSplit.add(this.treePanel);
        this.horizontalSplit.add(this.verticalSplit);
        this.horizontalSplit.setOneTouchExpandable(true);
        this.adjustDefaultSplitStatus();
        this.add((Component)this.horizontalSplit, "Center");
        this.add((Component)this.searchPanel, "North");
        this.searchPanel.addSelectionListener(new XMLPanelNodeSelectionListener(){

            @Override
            public void nodeSelected(Node node) {
                XMLStandardPanel.this.treePanel.setSelectedNode(node);
            }
        });
        this.searchPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                XMLStandardPanel.this.treePanel.setSelectedNode(XMLStandardPanel.this.treePanel.getNode());
            }
        });
        this.treePanel.addSelectionListener(new XMLPanelNodeSelectionListener(){

            @Override
            public void nodeSelected(Node node) {
                XMLStandardPanel.this.searchPanel.setNode(node);
                XMLStandardPanel.this.attrPanel.setNode(node);
                XMLStandardPanel.this.textPanel.setNode(node);
            }
        });
    }
}

