package csbase.client.applications.algorithmsmanager.report.core;

import java.util.ArrayList;
import java.util.List;

/**
 * Fbrica de objetos que sero analisados pelos testes.
 */
public abstract class AbstractSubjectFactory implements ISubjectFactory {

  /** Lista de quem escuta o cource */
  private List<SourceListener> listeners = new ArrayList<>();

  /** {@inheritDoc} */
  @Override
  public void addListener(SourceListener listener) {
    listeners.add(listener);
  };

  /** {@inheritDoc} */
  @Override
  public void removeListener(SourceListener listener) {
    listeners.remove(listener);
  }

  /** {@inheritDoc} */
  @Override
  public void callListeners() {
    listeners.forEach(SourceListener::sourceChanged);
  }
}
