package csbase.client.util.table;

/**
 * Evento Erro de Validao Resolvido.
 * 
 * @param <R> O valor armazenado na linha da tabela.
 */
public final class ValidationErrorWasResolvedEvent<R> {
  /**
   * A tabela.
   */
  private Table<R> table;

  /**
   * Cria o evento.
   * 
   * @param table A tabela (No aceita {@code null}).
   */
  public ValidationErrorWasResolvedEvent(Table<R> table) {
    setTable(table);
  }
  
  /**
   * Obtm a tabela.
   * 
   * @return .
   */
  public Table<R> getTable() {
    return table;
  }

  /**
   * Atribui a tabela.
   * 
   * @param table A tabela (No aceita {@code null}).
   */
  private void setTable(Table<R> table) {
    if (table == null) {
      throw new IllegalArgumentException("O parmetro table est nulo.");
    }
    this.table = table;
  }
}
