/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.menu;

import csbase.client.util.csvpanel.columns.ColumnGenerator;
import csbase.client.util.csvpanel.columns.DirectoryListingColumnGeneratorDialog;
import csbase.client.util.csvpanel.columns.SequentialColumnGeneratorDialog;
import csbase.client.util.csvpanel.menu.CSVTablePopupMenu;
import csbase.client.util.csvpanel.table.CSVTable;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import tecgraf.javautils.gui.StandardDialogs;

public class ColumnGeneratorPopupMenu
extends CSVTablePopupMenu {
    private JMenuItem sequentialItem;
    private JMenuItem directoryMenuItem;

    public ColumnGeneratorPopupMenu(CSVTable table) {
        super(table);
        this.createMenu();
    }

    private void createMenu() {
        final String itemLabel = this.getString("generateSequentialColumn.item");
        this.sequentialItem = new JMenuItem(itemLabel);
        this.sequentialItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = SwingUtilities.getWindowAncestor(ColumnGeneratorPopupMenu.this.table);
                if (ColumnGeneratorPopupMenu.this.table.getSelectedRowCount() > 0 && ColumnGeneratorPopupMenu.this.table.getSelectedColumnCount() == 1) {
                    SequentialColumnGeneratorDialog dialog = new SequentialColumnGeneratorDialog(window);
                    dialog.setVisible(true);
                    ColumnGenerator<?> generator = dialog.getColumnGenerator();
                    if (generator != null) {
                        ColumnGeneratorPopupMenu.this.table.generateColum(generator, ColumnGeneratorPopupMenu.this.table.getSelectedRows(), ColumnGeneratorPopupMenu.this.table.getSelectedColumn());
                    }
                } else {
                    String message = ColumnGeneratorPopupMenu.this.getString("multipleColumnSelection.warning.message");
                    StandardDialogs.showWarningDialog((Component)window, (String)itemLabel, (String)message);
                }
            }
        });
        this.add(this.sequentialItem);
        String directoryItemLabel = this.getString("generateDirectoryListingColumn.item");
        this.directoryMenuItem = new JMenuItem(directoryItemLabel);
        this.directoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryListingColumnGeneratorDialog dialog = new DirectoryListingColumnGeneratorDialog(SwingUtilities.getWindowAncestor(ColumnGeneratorPopupMenu.this.table));
                dialog.setVisible(true);
                ColumnGenerator<?> generator = dialog.getColumnGenerator();
                if (generator != null) {
                    ColumnGeneratorPopupMenu.this.table.generateColum(generator, ColumnGeneratorPopupMenu.this.table.getSelectedRows(), ColumnGeneratorPopupMenu.this.table.getSelectedColumn());
                }
            }
        });
        this.add(this.directoryMenuItem);
    }

    @Override
    protected boolean shouldBeShown() {
        return super.shouldBeShown() && this.table.isEditable() && this.table.getRowCount() > 0;
    }

    @Override
    protected void updateItemStatus() {
    }
}

