/*
 * $Id: CloseLogAction.java 72790 2008-02-15 20:05:47Z clinio $
 */
package csbase.client.util.gui.log.actions;

import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.actions.core.AbstractLogFileAction;

/**
 * Fecha o arquivo de log corrente.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class CloseLogAction extends AbstractLogFileAction {

  /**
   * Construtor
   * 
   * @param logPanel o painel de log associado a ao.
   */
  public CloseLogAction(final LogPanel logPanel) {
    super(logPanel, ApplicationImages.ICON_CLOSE_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) throws Exception {
    getLogPanel().closeFile();    
  }
}
