package csbase.client.applications.algorithmsmanager.actions;

import java.util.Hashtable;

import javax.swing.ImageIcon;

import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmCreateDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmSelectionPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonSelectionPanel;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;

/**
 * Essa classe representa a ao de criar uma novo algoritmo, na funcionalidade
 * de gerenciamento de algoritmos.
 * 
 * O mtodo <code> handleEditOperation </code> deve ser redefinido para que seja
 * criado um painel para a criao da novo algoritmo.
 * 
 */
public class AlgorithmCreateAction extends CommonEditAction {
  /**
   * Painel de criao de algoritmo
   */
  private AlgorithmCreateDataPanel createPanel;

  /**
   * Constri a ao de criao de categorias de algoritmos.
   * 
   * @param selectionPanel painel de seleo de dados, onde essa ao foi
   *        originada
   * @param icon imagem da ao
   */
  public AlgorithmCreateAction(CommonSelectionPanel selectionPanel,
    ImageIcon icon) {
    super(selectionPanel, icon);
  }

  /**
   * (non-Javadoc)
   * 
   * @see csbase.client.applications.algorithmsmanager.actions.CommonEditAction#handleEditOperation()
   */
  @Override
  protected void handleEditOperation() {
    createPanel = new AlgorithmCreateDataPanel(this);
    getSelectionPanel().getManagementAction().setCreatePanel(createPanel);
    createPanel.initializeData();
  }

  /**
   * Cria efetivamente o algoritmo no servidor.
   * 
   * @param algoName nome do novo algoritmo
   * @param algoId identificador do novo algoritmo
   * @param fieldValues propriedades do algoritmo
   * 
   * @return o algoritmo efetivamente criado
   * 
   */
  public AlgorithmInfo createAlgorithm(String algoName, String algoId,
    Hashtable<String, String> fieldValues) {
    AlgorithmInfo algoInfo =
      AlgorithmManagementProxy.createAlgorithm(algoName, algoId, fieldValues,
        getApplication().getApplicationFrame());
    return algoInfo;
  }

  /**
   * Realiza o cancelamento da ao de criar uma categoria.
   * 
   */
  public void cancelCreation() {
    getSelectionPanel().getManagementAction().setCreatePanel(null);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public AlgorithmSelectionPanel getSelectionPanel() {
    return (AlgorithmSelectionPanel) super.getSelectionPanel();
  }
}
