package csbase.client.applications.serverdiagnostic;

import java.awt.GridBagLayout;

import javax.swing.JTabbedPane;

import tecgraf.javautils.gui.GBC;
import csbase.client.applications.ApplicationComponentPanel;
import csbase.client.applications.serverdiagnostic.basic.IdentificationInfoPanel;
import csbase.client.applications.serverdiagnostic.monitor.MonitorPanel;
import csbase.client.applications.serverdiagnostic.properties.PropertiesPanel;
import csbase.client.applications.serverdiagnostic.statistics.ServerStatisticsPanel;
import csbase.logic.diagnosticservice.ServerDiagnosticInfo;

/**
 * Painel principal da aplicao de diagnstico do servidor.
 * 
 * @author Tecgraf PUC-Rio
 */
public class ServerDiagnosticPanel extends
  ApplicationComponentPanel<ServerDiagnostic> {

  /**
   * Informaes consolidadas para exibir no painel de diagnstico do servidor.
   */
  private ServerDiagnosticInfo info;

  /**
   * Construtor.
   * 
   * @param application a aplicao que usa esse painel
   * @param info informaes consolidadas para exibir no painel de diagnstico
   *        do servidor
   */
  public ServerDiagnosticPanel(ServerDiagnostic application,
    ServerDiagnosticInfo info) {
    super(application);
    this.info = info;
    buildInterface();
  }

  /**
   * Constri o contedo do painel principal da aplicao.
   */
  private void buildInterface() {
    JTabbedPane tabbedPane = new JTabbedPane();
    tabbedPane.add(new IdentificationInfoPanel(this.getApplication(),
      info.basicInfo), getString("tab.identification"));
    tabbedPane.add(new MonitorPanel(this.getApplication(), info.openbusStatus,
      info.publishedComponentsStatus, info.csfsStatus, info.diskStatus),
      getString("tab.monitor"));
    tabbedPane.add(new PropertiesPanel(this.getApplication(),
      info.propertiesInfo), getString("tab.properties"));
    tabbedPane.add(new ServerStatisticsPanel(this.getApplication(),
      info.statisticsInfo), getString("tab.statistics"));
    // tabbedPane.add(new LogPanel(this.getApplication()), "Logs"); // mjulia REMOVER
    setLayout(new GridBagLayout());
    add(tabbedPane, new GBC(0, 0).both().insets(5));
  }
}
