package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.FlowTransferable;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.messages.CopyMessage;
import csbase.logic.algorithms.flows.Flow;

/**
 * Ao de menu popup que copia elementos de fluxo, incluindo o valor de seus
 * parmetros.
 */
public class CopyElementsAction extends FlowApplicationAction {

  /**
   * Cria a ao.
   * 
   * @param application A aplicao construtura de fluxos.
   */
  public CopyElementsAction(FlowApplication application) {
    super(application, FlowApplicationUI.COPY_NODE_ICON);
    updateEnabledStatus(getGraph());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    Graph graph = getGraph();
    /*
     * Cria um novo fluxo somente com os ns selecionados para cpia e o coloca
     * na rea de tranferncia
     */
    Flow flow =
      Graph.toFlow(null, null, graph.getSelectedNodes(), graph
        .getSelectedLinks());
    new CopyMessage(new FlowTransferable(flow)).sendVS(graph);
  }

  /**
   * Obtm o grafo corrente da aplicao.
   * 
   * @return o grafo.
   */
  private Graph getGraph() {
    FlowApplication application = getApplication();
    Workspace workspace = application.getWorkspace();
    Graph graph = workspace.getGraph();
    return graph;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementCreated(Graph graph, GraphElement element) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementRemoved(Graph graph, GraphElement element) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementSelected(Graph graph, GraphElement element) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasChangedWorkspace(Graph graph) {
    updateEnabledStatus(graph);
  }

  /**
   * Habilita/desabilita a ao, dependendo do estado do grafo.
   * 
   * @param graph O grafo.
   */
  private void updateEnabledStatus(Graph graph) {
    setEnabled(graph.hasSelectedElements());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasReseted(Graph graph) {
    setEnabled(false);
  }

}
