package csbase.client.util.table;

import csbase.exception.ParseException;

/**
 * Conversor de Valores de Clulas: converte o valor da viso para o modelo e
 * vice-versa.
 */
public interface Converter {

  /**
   * Converte o valor da viso para o valor do modelo.
   * 
   * @param value O valor do modelo (No aceita {@code null}).
   * 
   * @return O valor do modelo.
   * 
   * @throws ParseException Erro de sintaxe.
   */
  Object convertFromView(String value) throws ParseException;

  /**
   * Converte o valor do modelo para o valor da viso.
   * 
   * @param value O valor da viso (No aceita {@code null}).
   * 
   * @return O valor da viso.
   */
  String convertToView(Object value);
}