/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.svgpanel;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.net.URI;
import java.net.URL;
import javax.swing.JPanel;

public class SVGPanel
extends JPanel {
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    private SVGIcon icon = new SVGIcon();
    private int iconOrigWidth;
    private int iconOrigHeight;

    public final HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public final VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public final void setImageFromClassResource(Class<?> clazz, String path) {
        if (clazz == null) {
            String err = "Null class detected!";
            throw new IllegalArgumentException("Null class detected!");
        }
        if (path == null || path.trim().isEmpty()) {
            String err = "Null or empty resource path!";
            throw new IllegalArgumentException("Null or empty resource path!");
        }
        URL url = clazz.getResource(path);
        this.setImageFromURL(url);
    }

    public final void setImageFromURL(URL url) {
        if (url == null) {
            String err = "Null URL detected!";
            throw new IllegalArgumentException("Null URL detected!");
        }
        URI uri = SVGCache.getSVGUniverse().loadSVG(url);
        this.icon.setSvgURI(uri);
        this.iconOrigWidth = this.icon.getIconWidth();
        this.iconOrigHeight = this.icon.getIconHeight();
    }

    public final void setImage(SVGIcon icon) {
        if (icon == null) {
            String err = "Null icon detected!";
            throw new IllegalArgumentException("Null icon detected!");
        }
        this.icon = icon;
        this.iconOrigWidth = icon.getIconWidth();
        this.iconOrigHeight = icon.getIconHeight();
    }

    @Override
    public void paintComponent(Graphics g) {
        int y;
        int x;
        int h;
        int w;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.icon.getSvgURI() == null) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, width, height);
            return;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        double ratio = (double)width / (double)height;
        double iconRatio = (double)this.iconOrigWidth / (double)this.iconOrigHeight;
        if (ratio < 1.0) {
            w = width;
            h = (int)Math.round((double)w / iconRatio);
        } else {
            h = height;
            w = (int)Math.round(iconRatio * (double)h);
        }
        this.icon.setPreferredSize(new Dimension(w, h));
        this.icon.setAntiAlias(true);
        this.icon.setScaleToFit(true);
        switch (this.horizontalAlignment) {
            case LEFT: {
                x = 0;
                break;
            }
            case RIGHT: {
                x = width - this.icon.getIconWidth();
                break;
            }
            case CENTER: {
                x = (int)Math.round((double)(width - w) / 2.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad enum!");
            }
        }
        switch (this.verticalAlignment) {
            case TOP: {
                y = 0;
                break;
            }
            case BOTTOM: {
                y = height - this.icon.getIconHeight();
                break;
            }
            case CENTER: {
                y = (int)Math.round((double)(height - h) / 2.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad enum!");
            }
        }
        this.icon.paintIcon((Component)this, g, x, y);
    }

    public void setVerticalAligment(VerticalAlignment aligment) {
        this.verticalAlignment = aligment;
        this.repaint();
    }

    public void setHorizontalAligment(HorizontalAlignment aligment) {
        this.horizontalAlignment = aligment;
        this.repaint();
    }

    public static enum VerticalAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

