/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.newview;

import csbase.client.algorithms.commands.newview.CommandView;
import csbase.client.algorithms.commands.newview.CommandViewFrame;
import csbase.client.algorithms.commands.newview.CommandViewType;
import csbase.client.algorithms.commands.newview.FlowCommandView;
import csbase.client.algorithms.commands.newview.NodeCommandView;
import csbase.client.algorithms.commands.newview.SimpleCommandView;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.kernel.ClientException;
import csbase.client.util.gui.log.tab.AbstractTab;
import csbase.logic.CommandInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import tecgraf.javautils.core.lng.LNG;

public class CommandViewFactory {
    private static final String VIEW_INDEX_TEMPLATE = "|%s|";
    private static final String NODE_INDEX_TEMPLATE = "|%s||%s|";

    public static void showNodeView(CommandInfo command, DesktopComponentFrame owner, AbstractTab.TabType tabType, GraphNode node) throws ClientException {
        if (null == command) {
            throw new IllegalArgumentException("O par\u00e2metro command est\u00e1 nulo.");
        }
        if (null == owner) {
            throw new IllegalArgumentException("O par\u00e2metro owner est\u00e1 nulo.");
        }
        String index = String.format(NODE_INDEX_TEMPLATE, owner.getIndex(), node.getId());
        CommandViewFactory.showView(CommandViewType.NODE, command, node.getAlgorithmConfiguratorView().getConfigurator(), owner, tabType, index, node.getId());
    }

    public static void showCommandView(CommandInfo command, DesktopComponentFrame owner, AbstractTab.TabType tabType) throws ClientException {
        if (null == command) {
            throw new IllegalArgumentException("O par\u00e2metro command est\u00e1 nulo.");
        }
        if (null == owner) {
            throw new IllegalArgumentException("O par\u00e2metro owner est\u00e1 nulo.");
        }
        String index = String.format(VIEW_INDEX_TEMPLATE, command.getId());
        AlgorithmConfigurator configurator = CommandViewFactory.getConfigurator(command, owner);
        CommandViewType type = configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW ? CommandViewType.FLOW : CommandViewType.SIMPLE;
        CommandViewFactory.showView(type, command, configurator, owner, tabType, index);
    }

    private static void showView(CommandViewType viewType, CommandInfo command, AlgorithmConfigurator configurator, DesktopComponentFrame owner, AbstractTab.TabType tabType, String index) throws ClientException {
        CommandViewFactory.showView(viewType, command, configurator, owner, tabType, index, null);
    }

    private static void showView(CommandViewType viewType, CommandInfo command, AlgorithmConfigurator configurator, DesktopComponentFrame owner, AbstractTab.TabType tabType, String index, Integer nodeId) throws ClientException {
        CommandViewFrame view = (CommandViewFrame)DesktopComponentFrame.getDesktopComponentFrame(index);
        if (view == null) {
            CommandView panel;
            switch (viewType) {
                case FLOW: {
                    panel = new FlowCommandView(command, (FlowAlgorithmConfigurator)configurator);
                    break;
                }
                case SIMPLE: {
                    panel = new SimpleCommandView(command, configurator);
                    break;
                }
                case NODE: {
                    if (nodeId == null) {
                        throw new IllegalArgumentException("O par\u00e2metro node est\u00e1 nulo.");
                    }
                    panel = new NodeCommandView(nodeId, command, configurator);
                    break;
                }
                default: {
                    throw new ClientException(LNG.get((String)(CommandViewFactory.class.getSimpleName() + ".error.view.unknown")));
                }
            }
            view = new CommandViewFrame(panel, index, owner, command);
        }
        view.showTab(tabType);
    }

    private static AlgorithmConfigurator getConfigurator(final CommandInfo command, DesktopComponentFrame owner) throws ClientException {
        RemoteTask<AlgorithmConfigurator> task = new RemoteTask<AlgorithmConfigurator>(){

            public void performTask() throws Exception {
                AlgorithmConfigurator configurator = command.getConfigurator();
                this.setResult(configurator);
            }
        };
        task.setProgressDialogDelay(1);
        String msg = LNG.get((String)(CommandViewFactory.class.getSimpleName() + ".message.loading.configurator"));
        String title = LNG.get((String)(CommandViewFactory.class.getSimpleName() + ".window.title"));
        if (!task.execute(owner, title, msg)) {
            throw new ClientException(task.getError());
        }
        AlgorithmConfigurator configurator = (AlgorithmConfigurator)task.getResult();
        return configurator;
    }
}

