/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.filechooser.ClientSGAFileChooserUtil;
import csbase.logic.ClientSGAFile;
import csbase.logic.algorithms.parameters.ClientSGAFileParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class ClientSGAFileParameterView
extends SimpleParameterView<ClientSGAFile> {
    public ClientSGAFileParameterView(ClientSGAFileParameter parameter, ParameterView.Mode mode) {
        super(parameter, mode, new Object[0]);
    }

    @Override
    protected JComponent createConfigurationComponent(Object ... componentArgs) {
        return new ClientSGAFileConfigurationComponent();
    }

    @Override
    protected JComponent createReportComponent(Object ... componentArgs) {
        return new ClientSGAFileReportComponent((ClientSGAFileParameter)this.getParameter());
    }

    @Override
    protected void updateViewContents() {
        if (this.getComponent() instanceof ClientSGAFileConfigurationComponent) {
            ((ClientSGAFileConfigurationComponent)this.getComponent()).updateView();
        }
    }

    @Override
    public boolean fillVerticalSpace() {
        return false;
    }

    public static String formatPathNames(ClientSGAFile file) {
        StringBuilder pathNames = new StringBuilder();
        pathNames.append(file.getName());
        if (!file.getBrothers().isEmpty()) {
            for (ClientSGAFile brother : file.getBrothers()) {
                pathNames.append(",");
                pathNames.append(brother.getName());
            }
        }
        return pathNames.toString();
    }

    public static String formatPaths(ClientSGAFile file) {
        StringBuilder pathNames = new StringBuilder();
        pathNames.append(file.getStringPath());
        if (!file.getBrothers().isEmpty()) {
            for (ClientSGAFile brother : file.getBrothers()) {
                pathNames.append(",");
                pathNames.append(brother.getStringPath());
            }
        }
        return pathNames.toString();
    }

    private class ClientSGAFileReportComponent
    extends JPanel {
        public ClientSGAFileReportComponent(ClientSGAFileParameter parameter) {
            super(new GridBagLayout());
            JTextField sga = new JTextField();
            sga.setEditable(false);
            JTextField path = new JTextField();
            path.setEditable(false);
            ClientSGAFile value = (ClientSGAFile)parameter.getValue();
            if (value != null) {
                sga.setText(value.getSGAName());
                path.setText(ClientSGAFileParameterView.formatPaths(value));
            }
            this.add((Component)sga, new GBC(0, 0).horizontal().top(5).bottom(5));
            this.add((Component)path, new GBC(0, 1).horizontal().top(5).bottom(5));
        }
    }

    private class ClientSGAFileConfigurationComponent
    extends JPanel {
        private JComboBox sgaComboBox;
        private JTextField fileChoosed;
        private JButton chooserButton;

        public ClientSGAFileConfigurationComponent() {
            super(new GridBagLayout());
            this.sgaComboBox = new JComboBox<Object>(this.getComboList().toArray());
            this.fileChoosed = new JTextField();
            this.fileChoosed.setEditable(false);
            this.chooserButton = GUIUtils.createImageButton((Icon)ApplicationImages.ICON_BROWSEFILE_16);
            this.chooserButton.setEnabled(false);
            this.addListeners();
            this.buildInterface();
        }

        private void addListeners() {
            this.sgaComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientSGAFileConfigurationComponent.this.chooserButton.setEnabled(ClientSGAFileConfigurationComponent.this.sgaComboBox.getSelectedIndex() != 0);
                    ClientSGAFileConfigurationComponent.this.setParameter(null);
                }
            });
            this.chooserButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String sgaName = (String)ClientSGAFileConfigurationComponent.this.sgaComboBox.getSelectedItem();
                    ClientSGAFileParameter parameter = (ClientSGAFileParameter)ClientSGAFileParameterView.this.getParameter();
                    ClientSGAFile root = new ClientSGAFile(sgaName, "/");
                    root.setDir(true);
                    ClientSGAFile choosed = ClientSGAFileConfigurationComponent.this.getFilesSelected(parameter.isInputMode(), parameter.isShowFiles(), parameter.isMultipleSelection(), parameter.getTypes(), root);
                    ClientSGAFileConfigurationComponent.this.setParameter(choosed);
                }
            });
        }

        private ClientSGAFile getFilesSelected(boolean isInputMode, boolean onlyFiles, boolean isMultiple, List<String> types, ClientSGAFile root) {
            if (onlyFiles) {
                if (isInputMode) {
                    if (isMultiple) {
                        List<ClientSGAFile> files = ClientSGAFileChooserUtil.browseMultipleFilesInOpenMode(null, this.getString("select.paths"), types, root);
                        ClientSGAFile choosed = null;
                        if (files != null) {
                            for (ClientSGAFile f : files) {
                                if (choosed == null) {
                                    choosed = f;
                                    continue;
                                }
                                choosed.getBrothers().add(f);
                            }
                        }
                        return choosed;
                    }
                    return ClientSGAFileChooserUtil.browseSingleFileInOpenMode(null, this.getString("select.paths"), types, true, root);
                }
                return ClientSGAFileChooserUtil.browseSingleFileInSaveMode(null, this.getString("select.paths"), types, root);
            }
            if (isInputMode) {
                if (isMultiple) {
                    List<ClientSGAFile> files = ClientSGAFileChooserUtil.browseMultipleDirectoryInOpenMode(null, this.getString("select.paths"), types, root);
                    ClientSGAFile choosed = null;
                    if (files != null) {
                        for (ClientSGAFile f : files) {
                            if (choosed == null) {
                                choosed = f;
                                continue;
                            }
                            choosed.getBrothers().add(f);
                        }
                    }
                    return choosed;
                }
                return ClientSGAFileChooserUtil.browseSingleDirectoryInOpenMode(null, this.getString("select.paths"), types, true, root);
            }
            return ClientSGAFileChooserUtil.browseSingleDirectoryInSaveMode(null, this.getString("select.paths"), types, root);
        }

        private void buildInterface() {
            this.add((Component)this.sgaComboBox, new GBC(0, 0).right(5).horizontal());
            this.add((Component)this.fileChoosed, new GBC(0, 1).top(5).right(4).horizontal());
            this.add((Component)this.chooserButton, new GBC(1, 1).top(5).none());
        }

        private List<String> getComboList() {
            RemoteTask<List<String>> task = new RemoteTask<List<String>>(){

                protected void performTask() throws Exception {
                    AbstractList sgaNames;
                    SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
                    try {
                        sgaNames = sgaService.getAllSGANames();
                    }
                    catch (RemoteException e) {
                        sgaNames = new LinkedList();
                    }
                    this.setResult(sgaNames);
                }
            };
            boolean result = task.execute(null, this.getString("sga.names.task.title"), this.getString("sga.names.task.body"));
            LinkedList<String> comboList = new LinkedList<String>();
            comboList.add(this.getString("select.sga"));
            if (result) {
                comboList.addAll((Collection)task.getResult());
            }
            return comboList;
        }

        private void setParameter(ClientSGAFile file) {
            ((SimpleParameter)ClientSGAFileParameterView.this.getParameter()).setValue((Object)file);
            if (file == null) {
                this.fileChoosed.setText("");
            } else {
                this.fileChoosed.setText(ClientSGAFileParameterView.formatPaths(file));
            }
        }

        private String getString(String key) {
            return LNG.get((String)(this.getClass().getSimpleName() + "." + key));
        }

        public void updateView() {
            ActionListener[] actionListeners;
            ClientSGAFile value = (ClientSGAFile)((SimpleParameter)ClientSGAFileParameterView.this.getParameter()).getValue();
            if (value == null) {
                return;
            }
            for (ActionListener l : actionListeners = this.sgaComboBox.getActionListeners()) {
                this.sgaComboBox.removeActionListener(l);
            }
            this.sgaComboBox.setSelectedItem(value.getSGAName());
            for (ActionListener l : actionListeners) {
                this.sgaComboBox.addActionListener(l);
            }
            this.fileChoosed.setText(ClientSGAFileParameterView.formatPaths(value));
            this.chooserButton.setEnabled(this.sgaComboBox.getSelectedIndex() != 0);
        }
    }
}

