/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ComponentProperties;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.client.applications.ApplicationImages;
import csbase.client.util.ClientUtilities;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileListParameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public abstract class FileListParameterView
extends SimpleParameterView<List<FileParameterValue>> {
    protected static final String LNGPREFIX = FileListParameterView.class.getName() + ".";

    public FileListParameterView(FileListParameter parameter, ParameterView.Mode mode) {
        super(parameter, mode, new Object[0]);
        this.updateViewContents();
        this.updateCapabilityView();
        this.updateVisibilyView();
    }

    @Override
    protected JComponent createConfigurationComponent(Object ... componentArgs) {
        return new FileListConfigurationParameter();
    }

    @Override
    protected JComponent createReportComponent(Object ... componentArgs) {
        return new FileListReportParameter();
    }

    @Override
    protected void updateViewContents() {
        ((FileListParameterComponent)((Object)this.getComponent())).updateViewContents();
    }

    @Override
    public boolean fillVerticalSpace() {
        return true;
    }

    @Override
    public FileListParameter getParameter() {
        return (FileListParameter)super.getParameter();
    }

    protected abstract Set<FileParameterValue> askForFile();

    final class FileListConfigurationParameter
    extends JPanel
    implements FileListParameterComponent {
        private final JButton addButton = new JButton();
        private boolean isEnabledView;
        private JList list;
        private DefaultListModel model;
        private final JButton removeButton = new JButton();
        private final JButton upButton = new JButton();
        private final JButton dnButton = new JButton();

        FileListConfigurationParameter() {
            this.setLayout(new BorderLayout());
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.getSelectionModel().setSelectionMode(2);
            this.list.setToolTipText(FileListParameterView.this.getParameter().getDescription());
            this.list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    switch (keyCode) {
                        case 8: 
                        case 127: {
                            FileListConfigurationParameter.this.removeFiles();
                        }
                    }
                }
            });
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    FileListConfigurationParameter.this.updateRemoveButton();
                    FileListConfigurationParameter.this.updateUpDownButton();
                }
            });
            this.list.setToolTipText(FileListParameterView.this.getParameter().getDescription());
            JPanel editPanel = new JPanel();
            editPanel.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(this.list), "Center");
            this.add((Component)this.createButtonPanel(), "East");
        }

        @Override
        public void updateViewContents() {
            this.model.removeAllElements();
            List values = (List)FileListParameterView.this.getParameter().getValue();
            if (values != null) {
                for (FileParameterValue value : values) {
                    this.model.addElement(value);
                }
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.isEnabledView = isEnabled;
            this.list.setEnabled(isEnabled);
            this.addButton.setEnabled(isEnabled);
            this.updateRemoveButton();
            this.updateUpDownButton();
        }

        private JPanel createButtonPanel() {
            final FileListParameter parameter = FileListParameterView.this.getParameter();
            this.addButton.setIcon(ApplicationImages.ICON_BROWSEFILE_16);
            this.addButton.setText(LNG.get((String)(LNGPREFIX + "add.button.text")));
            this.addButton.setToolTipText(LNG.get((String)(LNGPREFIX + "add.button.tooltip")));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Set<FileParameterValue> files = FileListParameterView.this.askForFile();
                    if (files != null) {
                        for (FileParameterValue file : files) {
                            parameter.addElement((Object)file);
                        }
                    }
                }
            });
            this.removeButton.setIcon(ApplicationImages.ICON_DELETE_16);
            this.removeButton.setText(LNG.get((String)(LNGPREFIX + "del.button.text")));
            this.removeButton.setToolTipText(LNG.get((String)(LNGPREFIX + "del.button.tooltip")));
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileListConfigurationParameter.this.removeFiles();
                }
            });
            this.removeButton.setEnabled(false);
            this.upButton.setIcon(ApplicationImages.ICON_UP_16);
            this.upButton.setText(LNG.get((String)(LNGPREFIX + "up.button.text")));
            this.upButton.setToolTipText(LNG.get((String)(LNGPREFIX + "up.button.tooltip")));
            this.upButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileListConfigurationParameter.this.moveUpFile();
                }
            });
            this.upButton.setEnabled(false);
            this.dnButton.setIcon(ApplicationImages.ICON_DOWN_16);
            this.dnButton.setText(LNG.get((String)(LNGPREFIX + "down.button.text")));
            this.dnButton.setToolTipText(LNG.get((String)(LNGPREFIX + "down.button.tooltip")));
            this.dnButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileListConfigurationParameter.this.moveDownFile();
                }
            });
            this.dnButton.setEnabled(false);
            ClientUtilities.adjustEqualSizes(this.addButton, this.removeButton, this.upButton, this.dnButton);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            buttonPanel.add((Component)this.addButton, new GBC(0, 0).center().none().insets(2));
            buttonPanel.add((Component)this.removeButton, new GBC(0, 1).center().none().insets(2));
            if (!parameter.mustSort()) {
                buttonPanel.add((Component)new JLabel(), new GBC(0, 2).center().vertical().insets(2));
                buttonPanel.add((Component)this.upButton, new GBC(0, 3).center().none().insets(2));
                buttonPanel.add((Component)this.dnButton, new GBC(0, 4).center().none().insets(2));
            }
            return buttonPanel;
        }

        private void removeFiles() {
            int[] selIdxs = this.list.getSelectedIndices();
            FileParameterValue[] files = new FileParameterValue[selIdxs.length];
            int i = 0;
            for (int selIdx : selIdxs) {
                ListModel listModel = this.list.getModel();
                FileParameterValue file = (FileParameterValue)listModel.getElementAt(selIdx);
                files[i++] = file;
            }
            FileListParameter parameter = FileListParameterView.this.getParameter();
            for (FileParameterValue file : files) {
                parameter.removeElementObj((Object)file);
            }
        }

        private void moveUpFile() {
            int[] indexes = this.list.getSelectedIndices();
            int n = indexes.length;
            if (n != 1) {
                return;
            }
            int index = indexes[0];
            FileListParameter parameter = FileListParameterView.this.getParameter();
            parameter.moveUp(index);
            this.list.setSelectedIndex(index - 1);
        }

        private void moveDownFile() {
            int[] indexes = this.list.getSelectedIndices();
            int n = indexes.length;
            if (n != 1) {
                return;
            }
            int index = indexes[0];
            FileListParameter parameter = FileListParameterView.this.getParameter();
            parameter.moveDown(index);
            this.list.setSelectedIndex(index + 1);
        }

        private void updateRemoveButton() {
            this.removeButton.setEnabled(this.isEnabledView && !this.list.isSelectionEmpty());
        }

        private void updateUpDownButton() {
            int[] selection = this.list.getSelectedIndices();
            boolean flag = this.isEnabledView && !this.list.isSelectionEmpty() && selection.length == 1;
            this.upButton.setEnabled(flag);
            this.dnButton.setEnabled(flag);
        }
    }

    final class FileListReportParameter
    extends JPanel
    implements FileListParameterComponent {
        private JTextArea textArea;

        FileListReportParameter() {
            this.setLayout(new GridLayout());
            this.textArea = new JTextArea();
            this.textArea.setToolTipText(FileListParameterView.this.getParameter().getDescription());
            ComponentProperties.setProperties(this.textArea, ParameterView.Mode.REPORT, false);
            JScrollPane scroll = new JScrollPane(this.textArea);
            scroll.setBorder(ComponentProperties.getInstance(ParameterView.Mode.REPORT).getBorder());
            this.updateViewContents();
            this.add((Component)scroll, new GBC(0, 0).both());
        }

        @Override
        public void updateViewContents() {
            List values = (List)FileListParameterView.this.getParameter().getValue();
            if (values == null) {
                this.textArea.setRows(1);
            } else {
                this.textArea.setRows(Math.max(1, Math.min(values.size(), 6)));
                StringBuffer sb = new StringBuffer();
                for (FileParameterValue value : values) {
                    sb.append(value.getPath()).append('\n');
                }
                String text = sb.substring(0, sb.length() - 1);
                this.textArea.setText(text);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.textArea.setEnabled(enabled);
        }
    }

    protected static interface FileListParameterComponent {
        public void updateViewContents();
    }
}

