/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ComponentProperties;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.TextParameterListener;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTextField;

public final class TextParameterView
extends SimpleParameterView<String> {
    @Deprecated
    public TextParameterView(Window window, TextParameter parameter) {
        this(parameter, ParameterView.Mode.CONFIGURATION);
    }

    public TextParameterView(TextParameter parameter, ParameterView.Mode mode) {
        super(parameter, mode, new Object[0]);
        this.updateCapabilityView();
        this.updateVisibilyView();
    }

    @Override
    public TextParameter getParameter() {
        return (TextParameter)super.getParameter();
    }

    @Override
    protected JComponent createConfigurationComponent(Object ... componentArgs) {
        return new TextConfigurationParameter();
    }

    @Override
    protected JComponent createReportComponent(Object ... componentArgs) {
        return new TextReportParameter();
    }

    @Override
    protected void updateViewContents() {
        ((ITextParameterComponent)((Object)this.getComponent())).updateViewContents();
    }

    @Override
    public boolean fillVerticalSpace() {
        return false;
    }

    private final class TextConfigurationParameter
    extends JTextField
    implements ITextParameterComponent {
        private final Color DISABLED_BACKGROUND_COLOR = Color.LIGHT_GRAY;
        private Color defaultBackgroundColor = this.getBackground();

        TextConfigurationParameter() {
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    TextConfigurationParameter.this.updateModel();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.setToolTipText(TextParameterView.this.getParameter().getDescription());
            this.updateViewContents();
            this.updateEditabilityView();
            TextParameterView.this.getParameter().addTextParameterListener(new TextParameterListener(){

                public void editabilityWasChanged(TextParameter parameter) {
                    TextConfigurationParameter.this.updateEditabilityView();
                }
            });
        }

        @Override
        public void updateViewContents() {
            String value = (String)TextParameterView.this.getParameter().getValue();
            this.setText(null == value ? "" : value);
        }

        private void updateEditabilityView() {
            boolean isEditable = TextParameterView.this.getParameter().isEditable();
            this.setEditable(isEditable);
            if (isEditable) {
                this.setBackground(this.defaultBackgroundColor);
            } else {
                this.setBackground(this.DISABLED_BACKGROUND_COLOR);
            }
        }

        private void updateModel() {
            String text = this.getText();
            if (text.length() == 0) {
                TextParameterView.this.getParameter().setValue(null);
            } else {
                TextParameterView.this.getParameter().setValue((Object)text);
            }
        }
    }

    private final class TextReportParameter
    extends JTextField
    implements ITextParameterComponent {
        TextReportParameter() {
            this.setToolTipText(TextParameterView.this.getParameter().getDescription());
            ComponentProperties.setProperties(this, ParameterView.Mode.REPORT, true);
            super.setEditable(false);
            this.updateViewContents();
        }

        @Override
        public void updateViewContents() {
            String value = (String)TextParameterView.this.getParameter().getValue();
            this.setText(null == value ? " " : value);
        }

        @Override
        public void setEditable(boolean enable) {
        }
    }

    private static interface ITextParameterComponent {
        public void updateViewContents();
    }
}

