/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.view.simple;

import csbase.client.algorithms.parameters.ParameterGroupView;
import csbase.client.algorithms.parameters.ParameterGroupViewListener;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.ParameterViewListener;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.client.algorithms.validation.ValidationTranslator;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.algorithms.view.AbstractAlgorithmConfiguratorPanel;
import csbase.client.kernel.ClientException;
import csbase.exception.algorithms.FormulaEvaluationException;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.ValidationExpression;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.panel.ExpandablePanel;
import tecgraf.javautils.gui.panel.ExpandablePanelGroup;

public class SimpleAlgorithmConfiguratorPanel
extends AbstractAlgorithmConfiguratorPanel<SimpleAlgorithmConfigurator> {
    private List<ParameterGroupView> groupViews;

    public SimpleAlgorithmConfiguratorPanel(Window owner, SimpleAlgorithmConfigurator configurator, ParameterView.Mode mode) throws ClientException {
        super(owner, configurator, mode);
    }

    @Override
    protected AbstractAlgorithmConfiguratorPanel.AbstractParametersPanel createParametersConfigurationPanel() {
        return new SimpleParametersConfigurationPanel();
    }

    @Override
    protected AbstractAlgorithmConfiguratorPanel.AbstractParametersPanel createParametersReportPanel() {
        return new SimpleParametersReportPanel();
    }

    public void addParameterGroupViewListener(ParameterGroupViewListener listener) {
        for (ParameterGroupView aGroupView : this.groupViews) {
            aGroupView.addParameterGroupViewListener(listener);
        }
    }

    private final class SimpleParametersReportPanel
    extends AbstractSimpleParametersPanel {
        protected SimpleParametersReportPanel() {
            super(ParameterView.Mode.REPORT);
        }
    }

    private final class SimpleParametersConfigurationPanel
    extends AbstractSimpleParametersPanel {
        protected SimpleParametersConfigurationPanel() {
            super(ParameterView.Mode.CONFIGURATION);
        }

        @Override
        protected void executeBeforeInitialization() {
            ((SimpleAlgorithmConfigurator)SimpleAlgorithmConfiguratorPanel.this.getConfigurator()).resetValues();
        }

        @Override
        protected void executeAfterInitialization() {
            ((SimpleAlgorithmConfigurator)SimpleAlgorithmConfiguratorPanel.this.getConfigurator()).updateTriggers();
        }
    }

    private abstract class AbstractSimpleParametersPanel
    extends AbstractAlgorithmConfiguratorPanel.AbstractParametersPanel {
        private JScrollPane mainPanel;

        protected AbstractSimpleParametersPanel(ParameterView.Mode mode) {
            this.executeBeforeInitialization();
            this.initialize(mode);
            this.executeAfterInitialization();
        }

        @Override
        public boolean highlightValidationResult(ViewValidationResult result) {
            ViewValidator element = (ViewValidator)result.getElement();
            if (element != null && !element.equals(this)) {
                boolean highlighted = false;
                for (ParameterGroupView groupView : SimpleAlgorithmConfiguratorPanel.this.groupViews) {
                    highlighted = highlighted || groupView.highlightValidationResult(result);
                }
                return highlighted;
            }
            if (!result.isWellSucceded()) {
                String message = ValidationTranslator.translateMessage((Validation)result);
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(SimpleAlgorithmConfiguratorPanel.this.getWindow(), message, "Erro no configurador de par\u00e2metros", 0);
                return true;
            }
            return false;
        }

        @Override
        public ViewValidationResult validate(ValidationMode mode) throws RemoteException {
            for (ParameterGroupView groupView : SimpleAlgorithmConfiguratorPanel.this.groupViews) {
                ViewValidationResult validation = groupView.validate(mode);
                if (validation.isWellSucceded()) continue;
                return validation;
            }
            SimpleAlgorithmConfigurator configurator = (SimpleAlgorithmConfigurator)SimpleAlgorithmConfiguratorPanel.this.getConfigurator();
            for (ValidationExpression expression : configurator.getExpressions()) {
                try {
                    if (expression.evaluate()) continue;
                    LinkedList parameterViews = new LinkedList();
                    for (SimpleParameter simpleParameter : expression.getParameters()) {
                        SimpleParameterView<?> parameterView = this.getParameterView(simpleParameter.getName());
                        parameterViews.add(parameterView);
                    }
                    for (SimpleParameterView simpleParameterView : parameterViews) {
                        simpleParameterView.highlightError();
                    }
                    for (SimpleParameterView simpleParameterView : parameterViews) {
                        simpleParameterView.clearError();
                    }
                    LocalizedMessage message = new LocalizedMessage(SimpleAlgorithmConfiguratorPanel.class, "expression.error", new Object[]{expression.getErrorMessage()});
                    return new ViewValidationResult(message, (ViewValidator)this);
                }
                catch (FormulaEvaluationException e) {
                    LocalizedMessage message = new LocalizedMessage(SimpleAlgorithmConfiguratorPanel.class, "formula.error", new Object[]{e.getLocalizedMessage()});
                    return new ViewValidationResult(message, (ViewValidator)this);
                }
            }
            return new ViewValidationResult(this);
        }

        protected void executeBeforeInitialization() {
        }

        protected void executeAfterInitialization() {
        }

        private void initialize(ParameterView.Mode mode) {
            SimpleAlgorithmConfiguratorPanel.this.groupViews = this.createGroupsView(mode);
            this.mainPanel = new JScrollPane();
            this.setLayout(new GridBagLayout());
            this.populateComponent(this.mainPanel, mode);
            this.add((Component)this.mainPanel, new GBC(0, 0).both());
        }

        private void populateComponent(JScrollPane scrollPane, ParameterView.Mode mode) {
            int verticalScrollValue = 0;
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            if (verticalScrollBar != null) {
                verticalScrollValue = verticalScrollBar.getValue();
            }
            JScrollBar horizontalScrollBar = scrollPane.getHorizontalScrollBar();
            int horizontalScrollValue = 0;
            if (horizontalScrollBar != null) {
                horizontalScrollValue = horizontalScrollBar.getValue();
            }
            JPanel groupViewsPanel = new JPanel(new GridBagLayout());
            GBC gbc = new GBC(1, 1).gridwidth(1).gridheight(1).weightx(1.0).insets(2, 2, 2, 2).northwest();
            ExpandablePanelGroup panelGroup = new ExpandablePanelGroup();
            int gridy = gbc.gridy + 1;
            boolean fillsVerticalSpace = false;
            for (ParameterGroupView groupView : SimpleAlgorithmConfiguratorPanel.this.groupViews) {
                JPanel aGroupViewPanel = groupView.getPanel();
                if (aGroupViewPanel == null) continue;
                groupView.populatePanel();
                if (aGroupViewPanel instanceof ExpandablePanel) {
                    ExpandablePanel expandablePanel = (ExpandablePanel)aGroupViewPanel;
                    if (groupView.fillVerticalSpace()) {
                        GBC newGBC = new GBC(gbc).horizontal().weighty(0.0).gridy(gridy);
                        GridBagLayout layout = new GridBagLayout();
                        layout.setConstraints((Component)expandablePanel, (GridBagConstraints)newGBC);
                        expandablePanel.setLayout((LayoutManager)layout);
                    }
                    panelGroup.add(new ExpandablePanel[]{expandablePanel});
                }
                GBC newGBC = new GBC(gbc).gridy(gridy++);
                if (groupView.fillVerticalSpace()) {
                    newGBC.both();
                } else {
                    newGBC.horizontal();
                }
                groupViewsPanel.add((Component)aGroupViewPanel, newGBC);
            }
            GBC newGBC = new GBC(gbc).gridy(gridy++);
            if (!fillsVerticalSpace) {
                newGBC.both();
                groupViewsPanel.add((Component)new JPanel(), newGBC);
            }
            scrollPane.setViewportView(groupViewsPanel);
            if (verticalScrollBar != null) {
                verticalScrollBar.setValue(verticalScrollValue);
            }
            if (horizontalScrollBar != null) {
                horizontalScrollBar.setValue(horizontalScrollValue);
            }
            scrollPane.revalidate();
        }

        private List<ParameterGroupView> createGroupsView(final ParameterView.Mode mode) {
            LinkedList<ParameterGroupView> views = new LinkedList<ParameterGroupView>();
            for (ParameterGroup group : ((SimpleAlgorithmConfigurator)SimpleAlgorithmConfiguratorPanel.this.getConfigurator()).getGroups()) {
                ParameterGroupView parameterGroupView = new ParameterGroupView(SimpleAlgorithmConfiguratorPanel.this, group, mode);
                views.add(parameterGroupView);
                parameterGroupView.addParameterViewListener(new ParameterViewListener(){

                    @Override
                    public void visibilityWasChanged(ParameterView<?> view) {
                        AbstractSimpleParametersPanel.this.populateComponent(AbstractSimpleParametersPanel.this.mainPanel, mode);
                    }
                });
                parameterGroupView.addParameterGroupViewListener(new ParameterGroupViewListener(){

                    @Override
                    public void childParameterVisibilityChanged(ParameterGroupView groupView) {
                        AbstractSimpleParametersPanel.this.populateComponent(AbstractSimpleParametersPanel.this.mainPanel, mode);
                    }
                });
            }
            return views;
        }

        private SimpleParameterView<?> getParameterView(String parameterName) {
            for (ParameterGroupView groupView : SimpleAlgorithmConfiguratorPanel.this.groupViews) {
                SimpleParameterView<?> parameterView = groupView.getParameterView(parameterName);
                if (parameterView == null) continue;
                return parameterView;
            }
            return null;
        }
    }
}

