/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.algorithmsmanager.actions.CommonVersionAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.VersionDialog;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.ClientUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;

public class VersionDuplicateAction
extends CommonVersionAction {
    public VersionDuplicateAction(AlgorithmVersionInfoPanel versionInfoPanel, ImageIcon icon) {
        super(versionInfoPanel, icon);
    }

    @Override
    protected void handleVersionOperation() {
        new DuplicateVersionDialog().show();
    }

    private class DuplicateVersionDialog
    extends VersionDialog {
        public DuplicateVersionDialog() {
            super(VersionDuplicateAction.this.getSelectedAlgorithm());
        }

        public void show() {
            this.dialogTitle = String.format(LNG.get((String)"algomanager.title.include_version"), this.algoInfo.getName());
            this.dialog = new DesktopComponentDialog(VersionDuplicateAction.this.getWindow());
            this.dialog.setTitle(this.dialogTitle);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DuplicateVersionDialog.this.dialog.close();
                }
            });
            JPanel infoPanel = new JPanel();
            JLabel idLabel = new JLabel(LNG.get((String)"algomanager.label.version_id"));
            this.majorField = new JTextField(3);
            this.minorField = new JTextField(3);
            this.patchField = new JTextField(3);
            infoPanel.add(idLabel);
            infoPanel.add(this.majorField);
            infoPanel.add(this.minorField);
            infoPanel.add(this.patchField);
            JPanel buttonsPanel = new JPanel();
            JButton includeButton = new JButton(LNG.get((String)"algomanager.button.include"));
            includeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] vNumbers = DuplicateVersionDialog.this.getVersionNumbers();
                    if (vNumbers != null) {
                        DuplicateVersionDialog.this.duplicateVersion(VersionDuplicateAction.this.getSelectedVersion().getId(), vNumbers[0], vNumbers[1], vNumbers[2]);
                        DuplicateVersionDialog.this.dialog.close();
                    }
                }
            });
            JButton cancelButton = new JButton(LNG.get((String)"algomanager.button.cancel"));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicateVersionDialog.this.dialog.close();
                }
            });
            ClientUtilities.adjustEqualSizes(includeButton, cancelButton);
            buttonsPanel.add(includeButton);
            buttonsPanel.add(cancelButton);
            Container cp = this.dialog.getContentPane();
            cp.add((Component)infoPanel, "Center");
            cp.add((Component)buttonsPanel, "South");
            this.dialog.pack();
            this.dialog.center(VersionDuplicateAction.this.getWindow());
            this.dialog.setVisible(true);
        }

        private void duplicateVersion(Object versionId, int major, int minor, int patch) {
            String algoId = this.algoInfo.getId();
            AlgorithmManagementProxy.duplicateVersion(algoId, versionId, major, minor, patch, VersionDuplicateAction.this.getWindow());
        }
    }
}

