/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.algorithmsmanager.actions.CommonVersionAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.desktop.LocalTask;
import csbase.client.desktop.RemoteTask;
import csbase.client.externalresources.ExternalResources;
import csbase.client.externalresources.LocalFile;
import csbase.client.externalresources.StandaloneLocalFile;
import csbase.client.externalresources.ZipLocalFile;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.SingletonFileChooser;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.CSBaseException;
import csbase.logic.SyncRemoteFileChannel;
import csbase.remote.ClientRemoteLocator;
import csbase.util.FileSystemUtils;
import csbase.util.Unzip;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.swing.ImageIcon;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class VersionImportAction
extends CommonVersionAction {
    private int selectionMode;
    private boolean multiSelectionEnabled;

    public VersionImportAction(AlgorithmVersionInfoPanel versionInfoPanel, ImageIcon icon) {
        super(versionInfoPanel, icon);
        this.setSelectionMode(2);
        this.multiSelectionEnabled = false;
        this.setEnabled(true);
    }

    @Override
    protected void handleVersionOperation() {
        if (this.getSelectedAlgorithm() == null) {
            return;
        }
        if (FileSystemUtils.canRead()) {
            this.fileSystemUpload();
        } else {
            this.appletUpload();
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    protected RemoteFileChannelInfo prepareUpload(String filePath) throws RemoteException {
        if (this.getSelectedAlgorithm() == null) {
            return null;
        }
        return ClientRemoteLocator.algorithmService.prepareUploadVersionPack((Object)this.getSelectedAlgorithm().getId(), filePath);
    }

    private void fileSystemUpload() {
        File[] sourceFiles = this.getSourceFiles();
        if (!this.validateFiles(sourceFiles)) {
            return;
        }
        LocalFile[] localFiles = this.createLocalFiles(sourceFiles);
        final ArrayList<RequestTransfer> requests = new ArrayList<RequestTransfer>();
        for (LocalFile sourceFile : localFiles) {
            RemoteFileChannelInfo requestInfo = this.getRequestInfo(sourceFile);
            if (requestInfo == null) continue;
            requests.add(new RequestTransfer(sourceFile, requestInfo));
        }
        LocalTask<Void> task = new LocalTask<Void>(){

            protected void performTask() throws Exception {
                for (RequestTransfer request : requests) {
                    request.transfer();
                }
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof IOException) {
                    error.printStackTrace();
                    StandardDialogs.showErrorDialog((Component)VersionImportAction.this.getWindow(), (String)VersionImportAction.this.getName(), (String)LNG.get((String)"algomanager.error.upload_fatal"));
                    return;
                }
                super.handleError(error);
            }
        };
        String waitMsg = LNG.get((String)"algomanager.msg.upload_wait");
        task.execute(this.getWindow(), this.getName(), waitMsg, false, true);
    }

    protected void appletUpload() {
        new ImportVersionDialog().show();
    }

    private File[] getSourceFiles() {
        SingletonFileChooser chooser = SingletonFileChooser.getInstance();
        chooser.setFileSelectionMode(this.getSelectionMode());
        chooser.setMultiSelectionEnabled(this.multiSelectionEnabled);
        int returnVal = chooser.showOpenDialog(this.getWindow());
        if (returnVal == 1) {
            return new File[0];
        }
        if (this.multiSelectionEnabled) {
            return chooser.getSelectedFiles();
        }
        return new File[]{chooser.getSelectedFile()};
    }

    private boolean validateFiles(File[] files) {
        return 0 < files.length && this.validateFileExists(files) && this.validateZip(files) && this.validateFileName(files);
    }

    private LocalFile[] createLocalFiles(File[] files) {
        try {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                try {
                    String fileName = String.format("%s.zip", file.getParentFile().getName());
                    return new LocalFile[]{new ZipLocalFile(fileName, files)};
                }
                catch (OutOfMemoryError e) {
                    String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal.outOfMemory");
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                    return new LocalFile[0];
                }
                catch (IOException e) {
                    String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal.io");
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                    return new LocalFile[0];
                }
                catch (Exception e) {
                    String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal");
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, e);
                    return new LocalFile[0];
                }
            }
            ArrayList<StandaloneLocalFile> sourceFiles = new ArrayList<StandaloneLocalFile>();
            for (File selFile : files) {
                if (selFile == null) continue;
                StandaloneLocalFile standAloneFile = new StandaloneLocalFile(selFile);
                sourceFiles.add(standAloneFile);
            }
            return sourceFiles.toArray(new LocalFile[sourceFiles.size()]);
        }
        catch (AccessControlException ex1) {
            String fatalErrorMsg = LNG.get((String)"algomanager.error.upload_fatal");
            if (!ExternalResources.getInstance().isEnabled()) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg);
                return null;
            }
            try {
                return ExternalResources.getInstance().openMultiFileDialog(".", null);
            }
            catch (CSBaseException ex2) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), fatalErrorMsg, ex2);
                return null;
            }
            catch (IOException ex3) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"algomanager.error.upload_io"), ex3);
                return null;
            }
        }
    }

    private RemoteFileChannelInfo getRequestInfo(LocalFile file) {
        String fileName;
        try {
            fileName = file.getName();
        }
        catch (IOException e) {
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"algomanager.error.upload_io"), e);
            return null;
        }
        RemoteTask<RemoteFileChannelInfo> prepareUploadTask = new RemoteTask<RemoteFileChannelInfo>(){

            protected void performTask() throws Exception {
                this.setResult(VersionImportAction.this.prepareUpload(fileName));
            }
        };
        String waitMsg = LNG.get((String)"algomanager.msg.upload_wait");
        if (!prepareUploadTask.execute(this.getWindow(), this.getName(), waitMsg, false, true)) {
            return null;
        }
        return (RemoteFileChannelInfo)prepareUploadTask.getResult();
    }

    private boolean validateFileExists(File[] files) {
        ArrayList<File> invalidFiles = new ArrayList<File>();
        for (File file : files) {
            if (file.exists()) continue;
            invalidFiles.add(file);
        }
        if (0 < invalidFiles.size()) {
            StringBuilder invalidFilesList = new StringBuilder();
            for (File file : invalidFiles) {
                invalidFilesList.append(String.format(LNG.get((String)"algomanager.error.upload_files_not_found.files.list"), file.getName()));
            }
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), String.format(LNG.get((String)"algomanager.error.upload_files_not_found"), invalidFilesList.toString()));
            return false;
        }
        return true;
    }

    private boolean validateZip(File[] files) {
        try {
            for (File file : files) {
                if (!file.getName().toLowerCase().endsWith("zip")) break;
                Unzip unzipped = new Unzip(file);
                List entries = unzipped.listZipEntries();
                for (ZipEntry entry : entries) {
                    String fileName = entry.getName().replaceAll("^(.*/)?([^/]+)/?$", "$2");
                    if (ClientUtilities.isValidFileName(fileName)) continue;
                    StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"UTIL_NAME_CHARACTER_ERROR"));
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"algomanager.error.upload_io"), e);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"UTIL_NAME_CHARACTER_ERROR"));
            return false;
        }
    }

    private boolean validateFileName(File ... files) {
        for (File file : files) {
            if (!ClientUtilities.isValidFileName(file.getName())) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), LNG.get((String)"UTIL_NAME_CHARACTER_ERROR"));
                return false;
            }
            if (!file.isDirectory() || this.validateFileName(file.listFiles())) continue;
            return false;
        }
        return true;
    }

    private class ImportVersionDialog {
        private ImportVersionDialog() {
        }

        public void show() {
            if (VersionImportAction.this.getSelectedAlgorithm() == null) {
                return;
            }
            if (ExternalResources.getInstance().isEnabled()) {
                String address = AlgorithmManagementProxy.getVersionURL(VersionImportAction.this.getSelectedAlgorithm().getId(), VersionImportAction.this.getWindow());
                if (address == null) {
                    return;
                }
                try {
                    URL url = new URL(address);
                    ExternalResources.getInstance().showDocument(url);
                }
                catch (Exception e) {
                    StandardErrorDialogs.showErrorDialog(VersionImportAction.this.getWindow(), LNG.get((String)"algomanager.title.error"), LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_IO_ERROR"), e);
                }
            } else {
                StandardDialogs.showInfoDialog((Component)VersionImportAction.this.getWindow(), (String)LNG.get((String)"algomanager.title.error"), (Object)LNG.get((String)"algomanager.error.upload_not_available"));
            }
        }
    }

    static class RequestTransfer {
        LocalFile file;
        RemoteFileChannelInfo info;

        RequestTransfer(LocalFile file, RemoteFileChannelInfo info) {
            this.file = file;
            this.info = info;
        }

        void transfer() throws Exception {
            SyncRemoteFileChannel channel = new SyncRemoteFileChannel(this.info.getIdentifier(), this.info.isWritable(), this.info.getHost(), this.info.getPort(), this.info.getKey());
            channel.open(!this.info.isWritable());
            InputStream inputStream = this.file.getInputStream();
            channel.syncTransferFrom(inputStream, 0L, this.file.getLength());
            inputStream.close();
            channel.close();
        }
    }
}

