/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.datatransfer;

import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.ITransferableSource;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.ITransferableTarget;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.VersionTreeClipboard;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class VersionTreeTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public void exportToClipboard(JComponent source, Clipboard clip, int action) {
        if (clip != null) {
            throw new IllegalArgumentException("Clipboard deve ser vazio.");
        }
        Transferable transferable = this.createTransferable(source);
        if (null != transferable) {
            VersionTreeClipboard.setObject(transferable);
        }
        super.exportToClipboard(source, clip, action);
    }

    @Override
    public void exportAsDrag(JComponent source, InputEvent e, int action) {
        VersionTreeClipboard.setObject(null);
        super.exportAsDrag(source, e, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transferable createTransferable(JComponent c) {
        if (c instanceof JTree) {
            JTree tree = (JTree)c;
            try {
                TreePath[] paths = tree.getSelectionPaths();
                if (null == paths) {
                    Transferable transferable = null;
                    return transferable;
                }
                Serializable[] data = new Serializable[paths.length];
                DataFlavor flavor = null;
                for (int inx = 0; inx < data.length; ++inx) {
                    Object node = paths[inx].getLastPathComponent();
                    if (!ITransferableSource.class.isAssignableFrom(node.getClass())) continue;
                    ITransferableSource source = (ITransferableSource)node;
                    if (null != flavor && !flavor.equals(source.getDataFlavor())) {
                        Transferable transferable = null;
                        return transferable;
                    }
                    data[inx] = source.getData();
                    flavor = source.getDataFlavor();
                }
                TransferableNode transferableNode = new TransferableNode(data, flavor);
                return transferableNode;
            }
            finally {
                tree.clearSelection();
            }
        }
        return null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport supp) {
        ITransferableTarget target = this.getDropTarget(supp);
        if (null == target) {
            return false;
        }
        try {
            Transferable transferable = supp.getTransferable();
            Object[] data = (Object[])transferable.getTransferData(supp.getDataFlavors()[0]);
            DataFlavor flavor = transferable.getTransferDataFlavors()[0];
            return target.canImport(data, flavor);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport supp) {
        try {
            Transferable transferable = supp.getTransferable();
            Object[] data = (Object[])transferable.getTransferData(supp.getDataFlavors()[0]);
            ITransferableTarget target = this.getDropTarget(supp);
            target.importData(data);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void exportDone(JComponent c, Transferable t, int action) {
    }

    private ITransferableTarget getDropTarget(TransferHandler.TransferSupport supp) {
        Object component;
        TreePath path = null;
        if (supp.isDrop()) {
            JTree.DropLocation dl = (JTree.DropLocation)supp.getDropLocation();
            path = dl.getPath();
        } else if (supp.getComponent() instanceof JTree) {
            path = ((JTree)supp.getComponent()).getSelectionPath();
        }
        if (null != path && null != (component = path.getLastPathComponent()) && ITransferableTarget.class.isAssignableFrom(component.getClass())) {
            return (ITransferableTarget)component;
        }
        return null;
    }

    public class TransferableNode
    implements Transferable {
        private final DataFlavor[] flavors;
        private final Serializable[] data;

        public TransferableNode(Serializable[] data, DataFlavor flavor) {
            this.data = data;
            this.flavors = new DataFlavor[]{flavor};
        }

        @Override
        public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (DataFlavor aFlavor : this.flavors) {
                if (!aFlavor.equals(flavor)) continue;
                return true;
            }
            return false;
        }
    }
}

