/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.panels.tablepanel;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.panels.core.FileExchangerPanel;
import csbase.client.applications.fileexchanger.panels.tablepanel.TableListModel;
import csbase.client.applications.fileexchanger.panels.tablepanel.TableListRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.table.SortableTable;

public class TableListPanel
extends FileExchangerPanel {
    private final SortableTable table = new SortableTable();

    public final int[] getSelectedIndexes() {
        return this.table.getSelectedRows();
    }

    private final void initTableAttributes() {
        this.table.setSelectionMode(2);
        final FileExchanger fileExchanger = this.getFileExchanger();
        TableListModel model = new TableListModel(fileExchanger);
        this.table.setModel((TableModel)model);
        TableListRenderer renderer = new TableListRenderer();
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)renderer);
        this.table.setDefaultRenderer(Double.class, (TableCellRenderer)renderer);
        this.table.setDefaultRenderer(Long.class, (TableCellRenderer)renderer);
        this.table.setDefaultRenderer(Integer.class, (TableCellRenderer)renderer);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                fileExchanger.selectionChanged();
            }
        });
    }

    private final void initTableWidthColumns() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int W = 30;
        int n = this.getFileExchanger().getNumShownColumns();
        int[] widths = new int[]{30, 60, 45, 75, 240, 240, 90, 90, 90, 90, 90, 30, 30};
        if (n > widths.length) {
            throw new RuntimeException("Internal error on alocation size");
        }
        for (int i = 0; i < n; ++i) {
            TableColumn col = columnModel.getColumn(i);
            col.setPreferredWidth(widths[i]);
        }
    }

    public void updateTable(boolean structureChanged) {
        int[] sels = this.table.getSelectedRows();
        TableListModel model = (TableListModel)this.table.getModel();
        if (structureChanged) {
            Vector<Integer> widthColList = new Vector<Integer>();
            TableColumnModel columnModel = this.table.getColumnModel();
            int columnCount = this.table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                TableColumn col = columnModel.getColumn(i);
                widthColList.add(col.getWidth());
            }
            model.fireTableStructureChanged();
            columnModel = this.table.getColumnModel();
            columnCount = this.table.getColumnCount();
            int updatedColumnCount = Math.min(widthColList.size(), columnCount);
            for (int i = 0; i < updatedColumnCount; ++i) {
                TableColumn col = columnModel.getColumn(i);
                col.setPreferredWidth((Integer)widthColList.get(i));
            }
        } else {
            model.fireTableDataChanged();
        }
        for (int sel : sels) {
            int nrows = this.table.getRowCount();
            if (sel >= nrows) continue;
            this.table.addRowSelectionInterval(sel, sel);
        }
    }

    public TableListPanel(FileExchanger fileExchanger) {
        super(fileExchanger);
        this.table.setNoSortStateEnabled(true);
        this.initTableAttributes();
        this.initTableWidthColumns();
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        this.add((Component)scrollPane, "Center");
        this.table.setAutoResizeMode(0);
        BorderUtil.setLowBorder((JComponent)scrollPane);
    }
}

