/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient;

import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationProject;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.FileTransferQueueThread;
import csbase.client.applications.filetransferclient.actions.ConnectionOffAction;
import csbase.client.applications.filetransferclient.actions.ConnectionOnAction;
import csbase.client.applications.filetransferclient.actions.DownloadAction;
import csbase.client.applications.filetransferclient.actions.FastConnectAction;
import csbase.client.applications.filetransferclient.actions.ToggleDotFilterLocalAction;
import csbase.client.applications.filetransferclient.actions.ToggleDotFilterRemoteAction;
import csbase.client.applications.filetransferclient.actions.UploadAction;
import csbase.client.applications.filetransferclient.dialogs.ConnectionFrame;
import csbase.client.applications.filetransferclient.panels.localpanel.FileTransferClientLocalPanel;
import csbase.client.applications.filetransferclient.panels.queuepanel.FileTransferClientQueuePanel;
import csbase.client.applications.filetransferclient.panels.remotepanel.FileTransferClientRemotePanel;
import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommonClientProject;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferPredefinedConnection;
import csbase.remote.FileTransferServiceInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.MenuButton;

public final class FileTransferClient
extends ApplicationProject {
    private final FileTransferQueueThread thread;
    private FileTransferConnection connection;
    private final FileTransferProxy serviceProxy;
    private final FileTransferClientRemotePanel remotePanel;
    private final FileTransferClientLocalPanel localPanel;
    private final FileTransferClientQueuePanel queuePanel;
    private final List<FileTransferPredefinedConnection> predefinedConnections;
    private ConnectionFrame connectionFrame;
    private final JButton downloadButton = new JButton();
    private final JButton uploadButton = new JButton();
    private final MenuButton fastConnectButton = new MenuButton((Icon)FileTransferClientUI.FAST_CONNECT_ICON, MenuButton.PopupPosition.BOTTOM);
    private final JMenu fastConnectItem = new JMenu();

    private JPanel buildButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.downloadButton.setAction(new DownloadAction(this));
        this.uploadButton.setAction(new UploadAction(this));
        panel.add((Component)new JPanel(), new GBC(0, 0).vertical().weighty(2.0));
        panel.add((Component)this.downloadButton, new GBC(0, 1).none());
        panel.add((Component)new JPanel(), new GBC(0, 2).vertical().weighty(1.0));
        panel.add((Component)this.uploadButton, new GBC(0, 3).none());
        panel.add((Component)new JPanel(), new GBC(0, 4).vertical().weighty(2.0));
        JComponent[] buttons = new JComponent[]{this.uploadButton, this.downloadButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        return panel;
    }

    private JMenu buildConectionMenu() {
        JMenu menu = new JMenu(this.getString("menu.connection"));
        this.fastConnectItem.setText(this.getString("menu.connection.fast"));
        JMenuItem manualConnectItem = menu.add(new ConnectionOnAction(this));
        manualConnectItem.setAccelerator(KeyStroke.getKeyStroke(77, 128));
        menu.add(manualConnectItem);
        menu.add(this.fastConnectItem);
        menu.add(new ConnectionOffAction(this));
        menu.addSeparator();
        menu.add(new ApplicationExitAction(this));
        return menu;
    }

    private JMenu buildConfigurationMenu() {
        JMenu menu = new JMenu(this.getString("menu.configuration"));
        JCheckBoxMenuItem localDotItem = new JCheckBoxMenuItem();
        localDotItem.setSelected(true);
        localDotItem.setAction(new ToggleDotFilterLocalAction(this));
        menu.add(localDotItem);
        JCheckBoxMenuItem remoteDotItem = new JCheckBoxMenuItem();
        remoteDotItem.setSelected(true);
        remoteDotItem.setAction(new ToggleDotFilterRemoteAction(this));
        menu.add(remoteDotItem);
        return menu;
    }

    private JMenu buildHelpMenu() {
        JMenu helpMenu = new JMenu(this.getString("menu.help"));
        helpMenu.add(new ApplicationAboutAction(this));
        return helpMenu;
    }

    private JSplitPane buildMainPanel() {
        JPanel buttonsPanel = this.buildButtonsPanel();
        JToolBar toolBar = this.buildToolBar();
        JPanel transfPanel = new JPanel(new GridBagLayout());
        transfPanel.add((Component)this.localPanel, new GBC(0, 0).both().weightx(20.0));
        transfPanel.add((Component)buttonsPanel, new GBC(1, 0).both().weightx(1.0));
        transfPanel.add((Component)this.remotePanel, new GBC(2, 0).both().weightx(20.0));
        transfPanel.setPreferredSize(new Dimension(800, 350));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolBar, new GBC(0, 0).horizontal());
        panel.add((Component)transfPanel, new GBC(0, 1).both());
        JSplitPane split = new JSplitPane(0);
        split.add(panel);
        split.add(this.queuePanel);
        split.setDividerLocation(0.9);
        split.setResizeWeight(0.9);
        split.setOneTouchExpandable(true);
        this.queuePanel.setPreferredSize(new Dimension(800, 100));
        return split;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu connMenu = this.buildConectionMenu();
        JMenu confMenu = this.buildConfigurationMenu();
        JMenu helpMenu = this.buildHelpMenu();
        menuBar.add(connMenu);
        menuBar.add(confMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private JToolBar buildToolBar() {
        JToolBar tb = new JToolBar(0);
        tb.setFloatable(false);
        tb.add(new ConnectionOnAction(this));
        tb.add(new ConnectionOffAction(this));
        tb.addSeparator();
        tb.add((Component)this.fastConnectButton);
        tb.addSeparator();
        tb.add(new ApplicationAboutAction(this));
        return tb;
    }

    public final FileTransferConnection getConnection() {
        return this.connection;
    }

    public FileTransferClientLocalPanel getLocalPanel() {
        return this.localPanel;
    }

    public final List<FileTransferPredefinedConnection> getPredefinedConnections() {
        return this.predefinedConnections;
    }

    public final Object getProjectId() {
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        CommonClientProject project = mainFrame.getProject();
        return project.getId();
    }

    public final FileTransferClientQueuePanel getQueuePanel() {
        return this.queuePanel;
    }

    public FileTransferClientRemotePanel getRemotePanel() {
        return this.remotePanel;
    }

    public final FileTransferProxy getServiceProxy() {
        return this.serviceProxy;
    }

    public final ConnectionFrame getSingleConnectionFrame() {
        if (this.connectionFrame == null) {
            this.connectionFrame = new ConnectionFrame(this);
        }
        return this.connectionFrame;
    }

    @Override
    public void killApplication() {
        if (this.thread != null) {
            this.thread.killThread();
        }
    }

    private void loadFastButtonActions() {
        int[] keys = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        int i = 0;
        for (FileTransferPredefinedConnection predef : this.predefinedConnections) {
            FastConnectAction action = new FastConnectAction(this, predef);
            JMenuItem itMenu = new JMenuItem(action);
            JMenuItem itButton = new JMenuItem(action);
            if (i < keys.length) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keys[i], 128);
                itMenu.setAccelerator(keyStroke);
                itButton.setAccelerator(keyStroke);
            }
            this.fastConnectButton.add(itButton);
            this.fastConnectItem.add(itMenu);
            ++i;
        }
        if (this.predefinedConnections.size() == 0) {
            this.fastConnectButton.setEnabled(false);
            this.fastConnectItem.setEnabled(false);
        }
    }

    public final void setConnection(FileTransferConnection connection) {
        this.connection = connection;
        if (connection == null) {
            this.downloadButton.setEnabled(false);
            this.uploadButton.setEnabled(false);
        } else {
            this.downloadButton.setEnabled(true);
            this.uploadButton.setEnabled(true);
        }
        this.localPanel.setLocalDirectory(null);
        this.remotePanel.setConnection(connection);
        this.remotePanel.setRemoteDirectory(null);
    }

    public void showExceptionDialog(Exception e) {
        String yes = this.getString("error.dialog.yes.option");
        String no = this.getString("error.dialog.no.option");
        String title = this.getString("error.dialog.title");
        String msg = this.getString("error.dialog.message");
        String question = this.getString("error.dialog.question");
        String exceptionMsg = e.getMessage();
        String text = msg + "\n\n" + exceptionMsg + "\n\n+" + question;
        Object[] options = new Object[]{yes, no};
        int op = JOptionPane.showOptionDialog(this.getApplicationFrame(), text, title, -1, 0, null, options, options[1]);
        if (op == 0) {
            this.showException(exceptionMsg, e);
        }
    }

    @Override
    public boolean userCanKillApplication() {
        return true;
    }

    public FileTransferClient(String id) {
        super(id);
        FileTransferServiceInterface fileTransferService = FileTransferProxy.getFileTransferService();
        if (fileTransferService != null) {
            this.thread = new FileTransferQueueThread(this);
            this.thread.start();
        } else {
            this.thread = null;
        }
        this.serviceProxy = new FileTransferProxy(this);
        this.predefinedConnections = this.serviceProxy.getPedefinedConnections();
        this.loadFastButtonActions();
        String serverName = FileTransferProxy.getServerName();
        this.remotePanel = new FileTransferClientRemotePanel(this);
        this.localPanel = new FileTransferClientLocalPanel(this, serverName);
        this.queuePanel = new FileTransferClientQueuePanel(this);
        ApplicationFrame mainFrame = this.getApplicationFrame();
        mainFrame.setJMenuBar(this.buildMenuBar());
        JSplitPane split = this.buildMainPanel();
        ((JFrame)mainFrame).getContentPane().add(split);
        mainFrame.pack();
        this.setConnection(null);
        this.queuePanel.refresh();
    }
}

