/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.jobmonitor.filters;

import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tecgraf.javautils.core.filter.IFilter;

public class JobInfoFilter
implements IFilter<JobInfoRow> {
    private Pattern pattern = Pattern.compile("");
    private List<String> columnsToFilter = new ArrayList<String>();
    private boolean wholeWord;

    public void setColumnsToFilter(List<String> columnsToFilter) {
        this.columnsToFilter = columnsToFilter;
    }

    public void setPattern(Pattern pattern) {
        if (pattern != null) {
            this.pattern = pattern;
        }
    }

    public void setWholeWord(boolean wholeWord) {
        this.wholeWord = wholeWord;
    }

    public boolean accept(JobInfoRow row) {
        if (this.columnsToFilter.isEmpty()) {
            return true;
        }
        for (String columnName : this.columnsToFilter) {
            String value = row.get(columnName);
            if (value == null) continue;
            Matcher matcher = this.pattern.matcher(value);
            if (!(this.wholeWord ? matcher.matches() : matcher.find())) continue;
            return true;
        }
        return false;
    }
}

