/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectInfoData;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.exception.BugException;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.DiskUsageServiceInterface;
import csbase.remote.ProjectServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FillProjectsTableAdminTask
extends ProjectsManagerTask<ProjectInfoData> {
    private boolean loadOccupiedSpace;
    private List<UserProjectInfo> failedProjects = new ArrayList<UserProjectInfo>();
    private HashSet<Object> projectWithAllocationSet = new HashSet();

    public FillProjectsTableAdminTask(ProjectsManager projectsManager, boolean loadOccupiedSpace) {
        super(projectsManager);
        this.loadOccupiedSpace = loadOccupiedSpace;
    }

    protected void performTask() throws Exception {
        List<ProjectsManagerData> projectsData = this.getProjectsData();
        ProjectInfoData pid = new ProjectInfoData(projectsData, this.failedProjects);
        this.setResult(pid);
    }

    private List<ProjectsManagerData> getProjectsData() throws Exception {
        ArrayList<ProjectsManagerData> projectList = new ArrayList<ProjectsManagerData>();
        this.getProjectsWithAllocation(projectList);
        this.getProjectsWithoutAllocation(projectList);
        return projectList;
    }

    private void getProjectsWithoutAllocation(List<ProjectsManagerData> projectList) throws RemoteException, Exception {
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        AdministrationServiceInterface asi = ClientRemoteLocator.administrationService;
        DiskUsageServiceInterface dus = ClientRemoteLocator.diskUsageService;
        List users = asi.getAllUsers();
        for (User user : users) {
            List userProjectsInfo = psi.getProjectsFromUser(user.getId());
            for (UserProjectInfo upi : userProjectsInfo) {
                CommonClientProject ccp;
                if (this.projectWithAllocationSet.contains(upi.getProjectId()) || !upi.getOwnerId().equals(user.getId())) continue;
                try {
                    ProjectAdminInfo projectAdminInfo = psi.getProjectAdminInfo(upi.getProjectId());
                    if (projectAdminInfo != null && (projectAdminInfo.isLocked() || projectAdminInfo.isWaitingAreaFree())) continue;
                    ccp = psi.openProject(upi.getProjectId(), false);
                }
                catch (BugException be) {
                    this.failedProjects.add(upi);
                    continue;
                }
                long allocatedSpace = ccp.getLockingAreaSize();
                ProjectSpaceAllocation psa = ProjectSpaceAllocation.getItemFromSpace(allocatedSpace);
                if (psa == ProjectSpaceAllocation.NO_ALLOCATION) {
                    ProjectsManagerData pmd = new ProjectsManagerData(ccp.getId(), ccp.getName(), ccp.getUserId());
                    pmd.setOwnerName(User.getName((Object)ccp.getUserId()));
                    pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.NO_ALLOCATION);
                    pmd.setProjectDescription(ccp.getDescription());
                    pmd.setCreationDate(ccp.getCreationDate());
                    pmd.setServerOwnerName(ccp.getOwnerServerName());
                    pmd.setLocationInServer(ccp.getLocationInServer());
                    pmd.setModificationDate(ccp.getLastModificationDate());
                    if (this.loadOccupiedSpace) {
                        pmd.setOccupiedSpace(dus.getUsedSpaceForProjectMb(ccp.getUserId(), ccp.getName()));
                    } else {
                        pmd.setOccupiedSpace(-1.0);
                    }
                    pmd.setSharingType(ccp.getSharingType());
                    pmd.setUsers(ccp.getUsersRO(), ccp.getUsersRW());
                    ccp.close(false);
                    projectList.add(pmd);
                    continue;
                }
                if (psa == ProjectSpaceAllocation.ALLOCATED) continue;
                this.failedProjects.add(upi);
            }
        }
    }

    private void getProjectsWithAllocation(List<ProjectsManagerData> projectList) throws RemoteException, Exception {
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        DiskUsageServiceInterface dus = ClientRemoteLocator.diskUsageService;
        ProjectAdminInfo[] allInfo = ProjectAdminInfo.getAll();
        if (allInfo == null) {
            return;
        }
        for (ProjectAdminInfo prjAdminInfo : allInfo) {
            ProjectsManagerData pmd;
            block12: {
                pmd = new ProjectsManagerData(prjAdminInfo.getProjectId(), prjAdminInfo.getProjectName(), prjAdminInfo.getOwnerId());
                pmd.setProjectDescription(null);
                pmd.setCreationDate(0L);
                pmd.setServerOwnerName("VAZIO1");
                pmd.setLocationInServer(prjAdminInfo.getAbsolutePath());
                pmd.setModificationDate(0L);
                pmd.setOccupiedSpace(0.0);
                pmd.setOwnerName(User.getName((Object)prjAdminInfo.getOwnerId()));
                if (prjAdminInfo.isUnlockedWithAreaAllocated()) {
                    pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.ALLOCATED);
                    long allocatedSpace = prjAdminInfo.getAreaLockedSize();
                    pmd.setAllocatedSpace(allocatedSpace);
                    try {
                        CommonClientProject ccp = psi.openProject(prjAdminInfo.getProjectId(), false);
                        if (ccp == null) break block12;
                        pmd.setProjectDescription(ccp.getDescription());
                        pmd.setCreationDate(ccp.getCreationDate());
                        pmd.setModificationDate(ccp.getLastModificationDate());
                        pmd.setLocationInServer(ccp.getLocationInServer());
                        if (this.loadOccupiedSpace) {
                            pmd.setOccupiedSpace(dus.getUsedSpaceForProjectMb(ccp.getUserId(), ccp.getName()));
                        } else {
                            pmd.setOccupiedSpace(-1.0);
                        }
                        try {
                            pmd.setSharingType(ccp.getSharingType());
                        }
                        catch (IllegalStateException ise) {
                            ccp.close(false);
                            continue;
                        }
                        pmd.setUsers(ccp.getUsersRO(), ccp.getUsersRW());
                        ccp.close(false);
                        break block12;
                    }
                    catch (BugException be) {
                        this.failedProjects.add((UserProjectInfo)prjAdminInfo);
                        continue;
                    }
                }
                if (prjAdminInfo.isLocked()) {
                    pmd.setRequestedSpace(prjAdminInfo.getAreaRequestSize());
                    pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.WAITING_ALLOCATION);
                    pmd.setScope(ProjectsManagerScope.NOT_APPLICABLE);
                    pmd.setSharingType(ProjectPermissions.SharingType.PRIVATE);
                    pmd.setUsers(new HashSet<Object>(), new HashSet<Object>());
                    pmd.setCreationDate(prjAdminInfo.getAreaRequestDate().getTime());
                } else if (prjAdminInfo.isWaitingAreaFree()) {
                    pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.WAITING_DEALLOCATION);
                    pmd.setScope(ProjectsManagerScope.NOT_APPLICABLE);
                    pmd.setSharingType(ProjectPermissions.SharingType.PRIVATE);
                }
            }
            this.projectWithAllocationSet.add(pmd.getProjectId());
            projectList.add(pmd);
        }
    }
}

