/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsynchronization;

import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PanelServerSelection
extends JPanel {
    private JRadioButton rdProjectLocal;
    private JRadioButton rdProjectRemote;
    private ButtonGroup bgProject;
    private JPanel projectServerInternalPanel;
    private JPanel projectLocalPanel;
    private JPanel projectRemotePanel;
    private JPanel projectSelectionServerPanel;
    private JTextField eUser;
    private JPasswordField ePassword;
    private JTextField eServer;
    private JFormattedTextField ePort;
    private ApplicationRegistry registry;

    public PanelServerSelection(String title, ApplicationRegistry registry, String server, String port) {
        super(new BorderLayout());
        this.registry = registry;
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.add((Component)this.getProjectSelectionServerPanel(), "North");
        this.add((Component)this.getProjectServerInternalPanel(), "Center");
        if (server != null && port != null) {
            this.rdProjectRemote.setSelected(true);
            this.eServer.setText(server);
            this.ePort.setText(port);
            CardLayout c = (CardLayout)this.getProjectServerInternalPanel().getLayout();
            c.show(this.getProjectServerInternalPanel(), "remoto");
        }
    }

    private JPanel getProjectSelectionServerPanel() {
        if (this.projectSelectionServerPanel == null) {
            this.projectSelectionServerPanel = new JPanel();
            this.bgProject = new ButtonGroup();
            this.bgProject.add(this.getRdProjectLocal());
            this.bgProject.add(this.getRdProjectRemote());
            this.projectSelectionServerPanel.add(this.getRdProjectLocal());
            this.projectSelectionServerPanel.add(this.getRdProjectRemote());
        }
        return this.projectSelectionServerPanel;
    }

    public JRadioButton getRdProjectLocal() {
        if (this.rdProjectLocal == null) {
            this.rdProjectLocal = new JRadioButton(this.registry.getString("step1.local"));
            this.rdProjectLocal.setSelected(true);
            this.rdProjectLocal.setFocusable(false);
            this.rdProjectLocal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CardLayout c = (CardLayout)PanelServerSelection.this.getProjectServerInternalPanel().getLayout();
                    c.show(PanelServerSelection.this.getProjectServerInternalPanel(), "local");
                }
            });
        }
        return this.rdProjectLocal;
    }

    public JRadioButton getRdProjectRemote() {
        if (this.rdProjectRemote == null) {
            this.rdProjectRemote = new JRadioButton(this.registry.getString("step1.remote"));
            this.rdProjectRemote.setFocusable(false);
            this.rdProjectRemote.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CardLayout c = (CardLayout)PanelServerSelection.this.getProjectServerInternalPanel().getLayout();
                    c.show(PanelServerSelection.this.getProjectServerInternalPanel(), "remoto");
                }
            });
        }
        return this.rdProjectRemote;
    }

    private JPanel getProjectServerInternalPanel() {
        if (this.projectServerInternalPanel == null) {
            this.projectServerInternalPanel = new JPanel();
            CardLayout cardLayout = new CardLayout();
            cardLayout.setHgap(3);
            cardLayout.setVgap(3);
            this.projectServerInternalPanel.setLayout(cardLayout);
            this.projectServerInternalPanel.add("local", this.getProjectLocalPanel());
            this.projectServerInternalPanel.add("remoto", this.getProjectRemotePanel());
        }
        return this.projectServerInternalPanel;
    }

    private JPanel getProjectLocalPanel() {
        if (this.projectLocalPanel == null) {
            this.projectLocalPanel = new JPanel();
        }
        return this.projectLocalPanel;
    }

    private JPanel getProjectRemotePanel() {
        if (this.projectRemotePanel == null) {
            this.projectRemotePanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.anchor = 17;
            c.insets = new Insets(2, 2, 0, 2);
            this.projectRemotePanel.add((Component)new JLabel(this.registry.getString("step1.server")), c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 2.0;
            c.fill = 2;
            c.insets = new Insets(0, 2, 2, 2);
            this.projectRemotePanel.add((Component)this.getEServer(), c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.anchor = 17;
            c.insets = new Insets(2, 2, 0, 2);
            this.projectRemotePanel.add((Component)new JLabel(this.registry.getString("step1.port")), c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(0, 2, 2, 2);
            this.projectRemotePanel.add((Component)this.getEPort(), c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.anchor = 17;
            c.insets = new Insets(2, 2, 0, 2);
            this.projectRemotePanel.add((Component)new JLabel(this.registry.getString("step1.user")), c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(0, 2, 2, 2);
            this.projectRemotePanel.add((Component)this.getEUser(), c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.anchor = 17;
            c.insets = new Insets(2, 2, 0, 2);
            this.projectRemotePanel.add((Component)new JLabel(this.registry.getString("step1.password")), c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 5;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(0, 2, 2, 2);
            this.projectRemotePanel.add((Component)this.getEPassword(), c);
        }
        this.projectRemotePanel.setPreferredSize(new Dimension(10, 250));
        return this.projectRemotePanel;
    }

    public JPasswordField getEPassword() {
        if (this.ePassword == null) {
            this.ePassword = new JPasswordField();
        }
        return this.ePassword;
    }

    public JTextField getEServer() {
        if (this.eServer == null) {
            this.eServer = new JTextField();
        }
        return this.eServer;
    }

    public JFormattedTextField getEPort() {
        if (this.ePort == null) {
            this.ePort = new JFormattedTextField(new DecimalFormat("#"));
            this.ePort.setColumns(7);
        }
        return this.ePort;
    }

    public JTextField getEUser() {
        if (this.eUser == null) {
            this.eUser = new JTextField();
        }
        return this.eUser;
    }
}

