/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.statsviewer;

import csbase.logic.eventlogservice.LogsInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LogsView {
    private List<String> selectedApplications;
    private List<String> selectedAlgorithms;
    private DateViewType selectedDateView;
    private LogsDataType selectedLogsType;
    private LogsInfo info;

    public LogsView() {
        this(DateViewType.YEAR, LogsDataType.LoginData);
    }

    public LogsView(DateViewType dateView, LogsDataType logsType) {
        this.selectedDateView = dateView;
        this.selectedLogsType = logsType;
        this.selectedApplications = new ArrayList<String>();
        this.selectedAlgorithms = new ArrayList<String>();
        this.info = new LogsInfo();
    }

    public void clear() {
        this.selectedApplications = new ArrayList<String>();
        this.selectedAlgorithms = new ArrayList<String>();
        this.info = new LogsInfo();
    }

    public void setSelectedApplications(List<String> applications) {
        this.selectedApplications = applications;
    }

    public void setSelectedAlgorithms(List<String> algorithms) {
        this.selectedAlgorithms = algorithms;
    }

    public void setInfo(LogsInfo info) {
        this.info = info;
    }

    public void setLogType(LogsDataType type) {
        this.selectedLogsType = type;
    }

    public void setDateViewType(DateViewType dateViewType) {
        this.selectedDateView = dateViewType;
    }

    public LogsDataType getLogType() {
        return this.selectedLogsType;
    }

    public LogsInfo getInfo() {
        return this.info;
    }

    public String[][] getTable() {
        List lines2;
        switch (this.selectedLogsType) {
            case LoginData: {
                lines2 = this.info.getLoginTable();
                break;
            }
            case ApplicationsData: {
                lines2 = this.info.getApplicationsTable();
                break;
            }
            case ExecutionsData: {
                List lines2 = this.info.getExecutionsTable();
            }
            default: {
                return null;
            }
        }
        return (String[][])lines2.toArray((T[])new String[lines2.size()][]);
    }

    public Map<String, Map<String, Integer>> getApplicationsMap() {
        TreeMap<String, Map<String, Integer>> map = new TreeMap<String, Map<String, Integer>>();
        for (String[] line : this.info.getApplicationsTable()) {
            Integer countApplications;
            String strDate = this.selectedDateView.getDateByView(line[0]);
            String appId = line[1];
            String appDesc = line[2];
            if (!this.selectedApplications.contains(appDesc)) continue;
            TreeMap<String, Integer> currentMap = (TreeMap<String, Integer>)map.get(strDate);
            if (currentMap == null) {
                currentMap = new TreeMap<String, Integer>();
                map.put(strDate, currentMap);
            }
            if ((countApplications = (Integer)currentMap.get(appDesc)) == null) {
                countApplications = 0;
            }
            currentMap.put(appDesc, countApplications + 1);
        }
        return map;
    }

    public Map<String, Map<String, Integer>> getAlgorithmsByDate() {
        TreeMap<String, Map<String, Integer>> map = new TreeMap<String, Map<String, Integer>>();
        for (String[] line : this.info.getExecutionsTable()) {
            Integer countApp;
            String strDate = this.selectedDateView.getDateByView(line[0]);
            String algorithm = line[1];
            if (!this.selectedAlgorithms.contains(algorithm)) continue;
            TreeMap<String, Integer> currentMap = (TreeMap<String, Integer>)map.get(strDate);
            if (currentMap == null) {
                currentMap = new TreeMap<String, Integer>();
                map.put(strDate, currentMap);
            }
            if ((countApp = (Integer)currentMap.get(algorithm)) == null) {
                countApp = 0;
            }
            currentMap.put(algorithm, countApp + 1);
        }
        return map;
    }

    public Map<String, Integer> getExecutionsByDate() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (String[] line : this.info.getExecutionsTable()) {
            String strDate = this.selectedDateView.getDateByView(line[0]);
            Integer value = (Integer)map.get(strDate);
            if (value == null) {
                value = 0;
            }
            map.put(strDate, value + 1);
        }
        return map;
    }

    public Map<String, Integer> getLoginsByDate() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (String[] line : this.info.getLoginTable()) {
            String strDate = this.selectedDateView.getDateByView(line[0]);
            Integer value = (Integer)map.get(strDate);
            if (value == null) {
                value = 0;
            }
            map.put(strDate, value + 1);
        }
        return map;
    }

    public Map<String, Integer> getTop10AlgorithmExecutions() {
        Map executionsByAlgorithmMap = this.info.getExecutionsByAlgorithm(this.selectedAlgorithms);
        return this.sortByValue(executionsByAlgorithmMap, 10);
    }

    public Map<String, Integer> getTop10UserExecutions() {
        Map executionsByUserMap = this.info.getExecutionsByUser(this.selectedAlgorithms);
        return this.sortByValue(executionsByUserMap, 10);
    }

    public Map<String, Integer> getTop10UserLogins() {
        Map loginsByUserMap = this.info.getLoginsByUser();
        return this.sortByValue(loginsByUserMap, 10);
    }

    private Map<String, Integer> sortByValue(Map<String, Integer> map, int n) {
        ArrayList<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> a, Map.Entry<String, Integer> b) {
                return -a.getValue().compareTo(b.getValue());
            }
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        int size = 0;
        for (Map.Entry entry : entries) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
            if (++size < n) continue;
            break;
        }
        return sortedMap;
    }

    public static enum DateViewType {
        YEAR,
        MONTH,
        DAY;


        public String getDateByView(String date) {
            switch (this) {
                case YEAR: {
                    return date.substring(0, 4);
                }
                case MONTH: {
                    return date.substring(0, 7);
                }
            }
            return date.substring(0, 10);
        }
    }

    public static enum LogsDataType {
        LoginData(new String[][]{{"client", "Desktop"}}),
        ApplicationsData(new String[][]{{"client", "Applications"}}),
        ExecutionsData(new String[][]{{"server", "commands", "simple"}, {"server", "commands", "flow"}});

        public String[][] queues;

        private LogsDataType(String[][] queues) {
            this.queues = queues;
        }
    }
}

