/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.statsviewer;

import csbase.client.ClientLocalFile;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.statsviewer.FilterPanel;
import csbase.client.applications.statsviewer.GraphicTabsPanel;
import csbase.client.applications.statsviewer.LogsView;
import csbase.client.applications.statsviewer.SearchPanel;
import csbase.client.remote.srvproxies.EventLogProxy;
import csbase.client.util.csvpanel.CSVFileUtils;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.eventlogservice.LogsInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;

public class StatsViewer
extends Application {
    private List<Observer> observers;
    private LogsView logsView = new LogsView();
    private SearchPanel searchPanel;
    private FilterPanel filterPanel;
    private GraphicTabsPanel graphicsTabPanel;

    public StatsViewer(String id) {
        super(id);
        this.observers = new ArrayList<Observer>();
        this.buildInterface();
    }

    @Override
    public void addObserver(Observer o) {
        this.observers.add(o);
    }

    @Override
    public void notifyObservers() {
        for (Observer observer : this.observers) {
            observer.update(this, this.logsView);
        }
    }

    public void clearInfo() {
        this.logsView.clear();
        this.filterPanel.updateInfo(this.logsView.getInfo());
        this.notifyObservers();
    }

    public void find(Date start, Date end) {
        LogsInfo info = EventLogProxy.find(this.logsView.getLogType().queues, start, end);
        this.logsView.setInfo(info);
        this.filterPanel.updateInfo(info);
        this.notifyObservers();
    }

    public void exportCSV() {
        ArrayList<String> fileCodes = new ArrayList<String>();
        fileCodes.add("CSV");
        String title = String.format(this.getString("export.csv.title"), this.getString(this.logsView.getLogType().name()));
        ClientLocalFile csvLocalFile = ClientLocalFileChooserUtil.browseSingleFileInSaveMode(this.getApplicationFrame(), fileCodes, "CSV", title, true, ClientFileChooserUtils.getLocalHomeDirectory());
        if (csvLocalFile == null) {
            return;
        }
        try {
            int answerDialog;
            if (csvLocalFile.exists() && (answerDialog = StandardDialogs.showYesNoDialog((Component)this.getApplicationFrame(), (String)this.getString("warning.title"), (Object)this.getString("override.question"))) == 1) {
                return;
            }
            String[][] table = this.logsView.getTable();
            if (table == null) {
                this.showInformation(this.getString("emptyTable"));
                return;
            }
            CSVFileUtils.writeCSVFile(this.getApplicationFrame(), table, csvLocalFile);
        }
        catch (Exception e) {
            this.showException(this.getString("exportFileError"), e.getCause());
        }
    }

    public void setLogType(LogsView.LogsDataType logType) {
        this.logsView.setLogType(logType);
        this.filterPanel.setLogType(logType);
        this.graphicsTabPanel.setLogType(logType);
    }

    public void filterDateViewType(LogsView.DateViewType dateViewType) {
        this.logsView.setDateViewType(dateViewType);
        this.notifyObservers();
    }

    public void filterApplications(List<String> applications) {
        this.logsView.setSelectedApplications(applications);
        this.notifyObservers();
    }

    public void filterAlgorithms(List<String> algorithms) {
        this.logsView.setSelectedAlgorithms(algorithms);
        this.notifyObservers();
    }

    private void buildInterface() {
        ApplicationFrame mainFrame = this.getApplicationFrame();
        mainFrame.setJMenuBar(this.buildMenuBar());
        ((JFrame)mainFrame).getContentPane().add(this.buildSplitPane());
        mainFrame.setSize(new Dimension(800, 600));
        this.getApplicationFrame().getStatusBar().showStatusBar();
    }

    private JSplitPane buildSplitPane() {
        this.filterPanel = new FilterPanel(this);
        this.graphicsTabPanel = new GraphicTabsPanel(this);
        this.searchPanel = new SearchPanel(this);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)this.searchPanel, new GBC(0, 0));
        leftPanel.add((Component)this.filterPanel, new GBC(0, 1).both());
        JSplitPane splitPane = new JSplitPane(1, leftPanel, this.graphicsTabPanel);
        splitPane.setDividerLocation(200);
        splitPane.setOneTouchExpandable(true);
        return splitPane;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildApplicationMenu());
        menuBar.add(this.buildHelpMenu());
        return menuBar;
    }

    private JMenu buildApplicationMenu() {
        JMenu configMenu = new JMenu(this.getString("menu.stats"));
        configMenu.add(new ApplicationExitAction(this));
        return configMenu;
    }

    private JMenu buildHelpMenu() {
        JMenu helpMenu = new JMenu(this.getString("menu.help"));
        helpMenu.add(new ApplicationAboutAction(this));
        return helpMenu;
    }

    @Override
    public void killApplication() throws ApplicationException {
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }
}

