/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.statsviewer.graphic;

import csbase.client.ClientLocalFile;
import csbase.client.applications.statsviewer.StatsViewer;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.logic.eventlogservice.LogsInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;

public abstract class GraphicPanel
extends JPanel
implements Observer {
    protected JFreeChart graph;
    protected String title;
    private final DateFormat dfTitle;
    protected StatsViewer app;

    public GraphicPanel(StatsViewer viewer, String title) {
        this.app = viewer;
        this.title = title;
        this.dfTitle = DateFormat.getDateInstance(2, LNG.getLocale());
        viewer.addObserver(this);
    }

    protected void newBarChart3DPanel(String xAxisLabel, String yAxisLabel, boolean showLegend) {
        this.graph = ChartFactory.createBarChart3D((String)this.title, (String)xAxisLabel, (String)yAxisLabel, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)true, (boolean)false);
        CategoryPlot p = this.graph.getCategoryPlot();
        p.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
        this.setLayout(new GridBagLayout());
        ChartPanel chartPanel = new ChartPanel(this.graph);
        chartPanel.setPopupMenu(null);
        chartPanel.setBorder((Border)new TitledBorder(""));
        chartPanel.setLayout((LayoutManager)new GridBagLayout());
        JButton button = new JButton(new AbstractAction(this.app.getString("export.image")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientLocalFile imageFile = ClientLocalFileChooserUtil.browseSingleFileInSaveMode(GraphicPanel.this.app.getApplicationFrame(), null, "png", null, false, null);
                if (imageFile == null) {
                    return;
                }
                try {
                    if (imageFile.exists() && StandardDialogs.showYesNoDialog((Component)GraphicPanel.this.app.getApplicationFrame(), (String)GraphicPanel.this.app.getString("warning.title"), (Object)GraphicPanel.this.app.getString("override.question")) == 1) {
                        return;
                    }
                    ChartUtilities.saveChartAsJPEG((File)new File(imageFile.getStringPath()), (JFreeChart)GraphicPanel.this.graph, (int)800, (int)600);
                }
                catch (Exception exception) {
                    GraphicPanel.this.app.showException(GraphicPanel.this.app.getString("exportFileError"), exception);
                }
            }
        });
        GBC gbc = new GBC(0, 0).insets(10, 5, 5, 5).both();
        this.add((Component)chartPanel, gbc);
        gbc = new GBC(0, 1).insets(10, 5, 10, 5).east();
        this.add((Component)button, gbc);
    }

    public void updateSubTitle(LogsInfo info) {
        ArrayList<Object> list = new ArrayList<Object>();
        LegendTitle legendTitle = this.graph.getLegend();
        list.add(legendTitle);
        if (info != null) {
            Date initialDate = info.getStartDate();
            Date finalDate = info.getEndDate();
            if (initialDate != null && finalDate != null) {
                list.add(new TextTitle(String.format(this.app.getString("graphic.subtitle"), this.dfTitle.format(initialDate), this.dfTitle.format(finalDate))));
            }
        }
        this.graph.setSubtitles(list);
    }

    protected void updateMapDataSet(Map<String, Map<String, Integer>> map) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (String date : map.keySet()) {
            Map<String, Integer> valueMap = map.get(date);
            for (String key : valueMap.keySet()) {
                dataset.setValue((Number)valueMap.get(key), (Comparable)((Object)key), (Comparable)((Object)date));
            }
        }
        this.graph.getCategoryPlot().setDataset((CategoryDataset)dataset);
    }

    protected void updateSimpleDataSet(Map<String, Integer> map, String rowkey) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (String key : map.keySet()) {
            Integer number = map.get(key);
            dataset.setValue((Number)number, (Comparable)((Object)rowkey), (Comparable)((Object)key));
        }
        this.graph.getCategoryPlot().setDataset((CategoryDataset)dataset);
    }
}

