/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v1_0.core;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.csdk.v1_0.application.CSDKApplication;
import csbase.client.util.StandardErrorDialogs;
import csdk.v1_0.api.application.ApplicationException;
import csdk.v1_0.api.application.IApplicationContext;
import csdk.v1_0.api.application.IMessage;
import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.api.core.IContext;
import java.awt.Window;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public class CSDKEnvironment
implements ICSDKEnvironment {
    private final Map<Class<? extends IContext>, IContext> contexts;

    public CSDKEnvironment(Map<Class<? extends IContext>, IContext> contexts) {
        this.contexts = contexts;
    }

    public void finishApplication() {
        CSDKApplication app = this.getApplicationInstance();
        app.closeApplication();
    }

    public <T extends IContext> T getContext(Class<T> contextClass) {
        if (contextClass == null) {
            return null;
        }
        IContext context = this.contexts.get(contextClass);
        if (context != null) {
            try {
                IContext t = (IContext)contextClass.cast(context);
                if (!context.isActive()) {
                    t.onContextActivate();
                }
                return (T)t;
            }
            catch (Exception e) {
                this.handleException(e, null);
            }
        }
        return null;
    }

    public void handleException(Exception error, Window parent) {
        IApplicationContext appContext = (IApplicationContext)this.contexts.get(IApplicationContext.class);
        String title = null;
        if (appContext != null) {
            title = appContext.getApplicationName();
        }
        StandardErrorDialogs.showExceptionDialog(parent, title, error);
    }

    public String runApplication(String id) throws ApplicationException {
        ApplicationManager manager = ApplicationManager.getInstance();
        try {
            if (!manager.hasApplicationRegistry(id)) {
                return null;
            }
            Object app = manager.runApplication(id);
            if (app == null) {
                return null;
            }
            return ((ApplicationType)app).getInstanceId();
        }
        catch (csbase.client.applicationmanager.ApplicationException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private CSDKApplication getApplicationInstance() {
        ApplicationManager manager = ApplicationManager.getInstance();
        IApplicationContext appContext = (IApplicationContext)this.contexts.get(IApplicationContext.class);
        if (appContext != null) {
            return (CSDKApplication)manager.getApplicationInstance(appContext.getInstanceId());
        }
        return null;
    }

    public boolean sendMessage(String id, IMessage message) {
        ApplicationManager manager = ApplicationManager.getInstance();
        ApplicationType targetApp = manager.getApplicationInstance(id);
        if (targetApp == null) {
            return false;
        }
        CSDKApplication senderApp = this.getApplicationInstance();
        String senderId = null;
        if (senderApp != null) {
            senderId = senderApp.getInstanceId();
        }
        targetApp.sendMessage(message.getType(), message.getValue(), senderId);
        return true;
    }

    public void cleanup() {
        for (IContext context : this.contexts.values()) {
            if (!context.isActive()) continue;
            context.onContextDeactivate();
        }
        this.contexts.clear();
    }

    public Locale getLocale() {
        return LNG.getLocale();
    }

    public Charset getServerCharset() {
        return Client.getInstance().getSystemDefaultCharset();
    }

    public Charset getCharset() {
        return Client.getInstance().getClientHostCharset();
    }
}

